<?php

/***************** DO NOT EDIT THIS FILE *************************
******************************************************************

INFORMATION:
------------

This is a core theme file, you should not need to edit 
this file directly. Code changes maybe lost during updates.
 
EDITED BY: MARK FAIL
------------------------------------------------------------------

******************************************************************/

$gatway[1]['name'] 	= "Paypal Standard";
$gatway[1]['function'] 	= "gateway_paypal";
$gatway[1]['website'] 	= "http://www.paypal.com";
$gatway[1]['logo'] 		= "paypal.png";
$gatway[1]['callback'] 	= "yes";
$gatway[1]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_paypal',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Paypal Email', 'type' => 'text', 'fieldname' => 'paypal_email'
										   ),
							'3' => array(
											'name' => 'Return URL', 'type' => 'text', 'fieldname' => 'paypal_return'
										   ),
							'4' => array(
											'name' => 'Cancel URL', 'type' => 'text', 'fieldname' => 'paypal_cancel'
										   ),
							'5' => array(
											'name' => 'Notify URL', 'type' => 'text', 'fieldname' => 'paypal_notify'
										   ),
							'6' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'paypal_currency'
										   ),
							'7' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_paypal_name', 'default' => 'Pay Now with PayPal'
										   ),
							'8' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_paypal_icon',
										   ),
);

$gatway[2]['name'] 	= "Worldpay Gateway";
$gatway[2]['function'] 	= "gateway_worldpay";
$gatway[2]['logo'] 	= "worldpay.png";
$gatway[2]['website'] 	= "http://www.worldpay.com";
$gatway[2]['callback'] 	= "no";
$gatway[2]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_worldpay',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Install ID', 'type' => 'text', 'fieldname' => 'worldpay_instId'
										   ),
							'3' => array(
											'name' => 'Account ID', 'type' => 'text', 'fieldname' => 'worldpay_accId1'
										   ),
							'4' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'worldpay_currency'
										   ),
							'5' => array(
											'name' => 'Test Mode (101 or 100)', 'type' => 'text', 'fieldname' => 'worldpay_testmode'
										   ),
							'6' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_worldpay_name', 'default' => 'Pay Now with Worldpay'
										   ),
							'7' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_worldpay_icon',
										   ),
);





$gatway[4]['name'] 	= "Google Checkout";
$gatway[4]['logo'] 	= "google.png";
$gatway[4]['function'] 	= "gateway_google";
$gatway[4]['website'] 	= "http://checkout.google.com/sell";
$gatway[4]['callback'] 	= "no";
$gatway[4]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_google',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'google_merchant'
										   ),
							'3' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'google_currency'
										   ),
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_google_name', 'default' => 'Pay Now with Google Checkout'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_google_icon',
										   ),
							'6' => array(
											'name' => 'Return URL', 'type' => 'text', 'fieldname' => 'gateway_google_callback',
										   ),

);

//$gatway[5]['name'] 	= "Custom Gateway Setup";
//$gatway[5]['function'] 	= "gateway_custom";
/*$gatway[5]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_custom',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Form POST Link', 'type' => 'text', 'fieldname' => 'custom_form'
										   ),
							'3' => array(
											'name' => 'Forum Hidden Values', 'type' => 'textarea', 'fieldname' => 'custom_data'
										   ),
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_custom_name', 'default' => 'Pay Now'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_custom_icon',
										   ),

);*/

$gatway[6]['name'] 	= "Authorize.net Setup";
$gatway[6]['logo'] 	= "auth.png";
$gatway[6]['function'] 	= "gateway_authorize";
$gatway[6]['website'] 	= "http://www.authorize.net/";
$gatway[6]['callback'] 	= "yes";
$gatway[6]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_authorize',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Login ID', 'type' => 'text', 'fieldname' => 'authorize_loginID'
										   ),
							'3' => array(
											'name' => 'Transaction Key', 'type' => 'text', 'fieldname' => 'authorize_transactionID'
										   ),
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_authorize_name', 'default' => 'Pay Now Using Authorize.net'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_authorize_icon',
										   ),

							'6' => array(
											'name' => 'Callback URL', 'type' => 'text', 'fieldname' => 'authorize_callback',
										   ),
);


$gatway[7]['name'] 	= "Protx / SagPay Setup";
$gatway[7]['logo'] 	= "sagepay.png";
$gatway[7]['function'] 	= "gateway_protx";
$gatway[7]['website'] 	= "http://www.sagepay.com";
$gatway[7]['callback'] 	= "no";
$gatway[7]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_protx',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),							
										
							'3' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_protx_name', 'default' => 'Pay Now Using Protx'
										   ),
							'4' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_protx_icon',
										   ),
							'5' => array(
											'name' => 'Vendor Name', 'type' => 'text', 'fieldname' => 'protx_vendor'
										   ),
							'6' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'protx_currency'
										   ),
							'7' => array(
											'name' => 'Success URL', 'type' => 'text', 'fieldname' => 'protx_success'
										   ),
							'8' => array(
											'name' => 'Failure URL', 'type' => 'text', 'fieldname' => 'protx_fail'
										   ),
							'9' => array(
											'name' => 'Encryption Password', 'type' => 'text', 'fieldname' => 'protx_key'
										   ),

);

$gatway[8]['name'] 	= "CC Avenue Setup";
$gatway[8]['logo'] 	= "ccave.png";
$gatway[8]['function'] 	= "gateway_ccavenue";
$gatway[8]['website'] 	= "http://www.ccavenue.com";
$gatway[8]['callback'] 	= "no";
$gatway[8]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_ccavenue',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'ccavenue_merchantID'
										   ),
							'3' => array(
											'name' => 'Redirect URL', 'type' => 'text', 'fieldname' => 'ccavenue_url'
										   ),
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_ccavenue_name', 'default' => 'Pay Now Using CCavenue'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_ccavenue_icon',
										   ),
							'6' => array(
											'name' => 'Working Key', 'type' => 'text', 'fieldname' => 'ccavenue_key',
										   ),

);

$gatway[9]['name'] 	= "Alertpay Setup";
$gatway[9]['logo'] 	= "alterpay.png";
$gatway[9]['function'] 	= "gateway_alertpay";
$gatway[9]['website'] 	= "http://www.Alertpay.com";
$gatway[9]['callback'] 	= "no";
$gatway[9]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_alertpay',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Account No.', 'type' => 'text', 'fieldname' => 'alertpay_merchantID'
										   ),
							'3' => array(
											'name' => 'SubAcc No', 'type' => 'text', 'fieldname' => 'alertpay_subID'
										   ),
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_alertpay_name', 'default' => 'Pay Now Using AlertPay'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_alertpay_icon',
										   ),
							'6' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'alertpay_currency', 'default' => 'USD'
										   ),
							'7' => array(
											'name' => 'Cancel URL', 'type' => 'text', 'fieldname' => 'alertpay_fail',
										   ),
							'8' => array(
											'name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => 'alertpay_success',
										   ),

);

$gatway[10]['name'] 		= "eWay Setup";
$gatway[10]['logo'] 		= "eway.png";
$gatway[10]['function'] 	= "gateway_eWay";
$gatway[10]['website'] 		= "http://www.eWay.com";
$gatway[10]['callback'] 	= "no";
$gatway[10]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway','type' => 'listbox','fieldname' => 'gateway_eWay','list' => array('yes'=>'Enable','no'=>'Disable')   ),
'2' => array('name' => 'Customer ID', 'type' => 'text', 'fieldname' => 'eWay_customerID'),
'3' => array('name' => 'Customer UserName', 'type' => 'text', 'fieldname' => 'eWay_username'),
'4' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_eWay_name', 'default' => 'Pay Now Using eWay' ),
'5' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_eWay_icon'),
'6' => array('name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => 'eWay_returnURL'),

);

$gatway[11]['name'] 	= "2checkout Setup";
$gatway[11]['logo'] 		= "2co.png";
$gatway[11]['function'] 	= "gateway_2checkout";
$gatway[11]['website'] 		= "http://www.2checkout.com";
$gatway[11]['callback'] 	= "no";
$gatway[11]['fields'] 	= array(
'1' => array('name' => 'Enable Gateway','type' => 'listbox','fieldname' => 'gateway_2checkout','list' => array('yes'=>'Enable','no'=>'Disable',)),
'2' => array('name' => 'Customer SID', 'type' => 'text', 'fieldname' => '2checkout_customerID' ),
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_2checkout_name', 'default' => 'Pay Now Using 2checkout'  ),
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_2checkout_icon', 'default' => 'https://www.2checkout.com/images/2cocc04.gif' ),							
'5' => array('name' => 'Cancel URL', 'type' => 'text', 'fieldname' => '2checkout_fail'  ),
'6' => array('name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => '2checkout_returnURL'),
'7' => array('name' => 'Product ID', 'type' => 'text', 'fieldname' => '2checkout_productID'	   ),

);


$gatway[12]['name'] 	= "PayFast Setup";
$gatway[12]['logo'] 		= "fastpay.png";
$gatway[12]['function'] 	= "gateway_payfast";
$gatway[12]['website'] 		= "http://www.payfast.co.za";
$gatway[12]['callback'] 	= "no";
$gatway[12]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_payfast',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'payfast_ID'
										   ),
							'3' => array(
											'name' => 'Merchant Key', 'type' => 'text', 'fieldname' => 'payfast_key'
										   ),										   
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_payfast_name', 'default' => 'Pay Now Using payfast'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_payfast_icon',
										   ),
							
							'6' => array(
											'name' => 'Cancel URL', 'type' => 'text', 'fieldname' => 'payfast_fail',
										   ),
							'7' => array(
											'name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => 'payfast_return',
										   ),

);

$gatway[13]['name'] 	= "PayWeb Setup";
$gatway[13]['logo'] 		= "payweb.png";
$gatway[13]['function'] 	= "gateway_payweb";
$gatway[13]['website'] 		= "http://www.payweb.com";
$gatway[13]['callback'] 	= "no";
$gatway[13]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_payweb',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Pay Web ID', 'type' => 'text', 'fieldname' => 'payweb_ID'
										   ),
							'3' => array(
											'name' => 'Encryption Key', 'type' => 'text', 'fieldname' => 'payweb_key'
										   ),										   
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_payweb_name', 'default' => 'Pay Now Using payweb'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_payweb_icon',
										   ),
							
							'6' => array(
											'name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => 'payweb_return',
										   ),

);

$gatway[14]['name'] 		= "iDeal (mobile.nl) Setup";
$gatway[14]['logo'] 		= "mobil.png";
$gatway[14]['function'] 	= "gateway_ideal";
$gatway[14]['website'] 		= "http://www.mollie.nl";
$gatway[14]['callback'] 	= "yes";
$gatway[14]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_ideal',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'ideal_ID'
										   ),
												   
							'4' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_ideal_name', 'default' => 'Pay Now Using iDeal'
										   ),
							'5' => array(
											'name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_ideal_icon',
										   ),
							
							'6' => array(
											'name' => '(thank you) Return URL', 'type' => 'text', 'fieldname' => 'ideal_return',
										   ),

); 

$gatway[15]['name'] 	= "Paypal Payments Pro Setup";
$gatway[15]['logo'] 		= "paypalpro.png";
$gatway[15]['function'] 	= "gateway_paypalpro";
$gatway[15]['website'] 	= "http://www.paypal.com";
$gatway[15]['callback'] 	= "yes";
$gatway[15]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_paypalpro',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Username', 'type' => 'text', 'fieldname' => 'paypalpro_username'
										   ),
												   
							'4' => array(
											'name' => 'Password', 'type' => 'text', 'fieldname' => 'paypalpro_password', 
										   ),
							'5' => array(
											'name' => 'Signature', 'type' => 'text', 'fieldname' => 'paypalpro_sig',
										   ),
							
							'6' => array(
											'name' => 'Callback Page URL', 'type' => 'text', 'fieldname' => 'paypalpro_callback',
										   ),
							'7' => array(
											'name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'paypalpro_currency', 'default' => 'USD'
										   ),
										   
							'8' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_paypalpro_name', 'default' => 'Pay Now with PayPal'
										   ),

);
/*
$gatway[166]['name'] 	= "eWAY API Setup";
$gatway[166]['function'] 	= "gateway_ewayAPI";
$gatway[166]['website'] 	= "http://www.paypal.com";
$gatway[166]['callback'] 	= "no";
$gatway[166]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_ewayAPI',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Customer ID', 'type' => 'text', 'fieldname' => 'ewayAPI_customerID'
										   ), 
							'3' => array(
											'name' => 'Payment Method', 
											'type' => 'listbox', 
											'fieldname' => 'ewayAPI_paymentmethod',
											'list' => array(
												'REAL_TIME'=>'Real Time','REAL_TIME_CVN'=>'Real Time CVN','GEO_IP_ANTI_FRAUD'=>'GEO Anti Fraud',
											)
										   ),
						'4' => array(
											'name' => 'Live or Test', 
											'type' => 'listbox', 
											'fieldname' => 'ewayAPI_live',
											'list' => array(
												'true'=>'Live Gateway','false'=>'Test Gateway',
											)
										   ),
							
							'5' => array(
											'name' => 'Callback Page URL', 'type' => 'text', 'fieldname' => 'ewayAPI_callback',
										   ), 

);*/


$gatway[16]['name'] 	= "NoChex Setup";
$gatway[16]['logo'] 		= "nochex.png";
$gatway[16]['function'] = "gateway_nochex";
$gatway[16]['website'] 	= "http://www.nochex.com";
$gatway[16]['callback'] 	= "no";
$gatway[16]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_nochex', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'NoChex Email', 'type' => 'text', 'fieldname' => 'nochex_mid'), 
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_nochex_name', 'default' => 'Pay Now Using NoChex'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_nochex_icon' ),
'5' => array('name' => 'Callback URL', 'type' => 'text', 'fieldname' => 'gateway_nochex_callback' ),
);


$gatway[17]['name'] 	= "ePay Setup";
$gatway[17]['logo'] 		= "epay.png";
$gatway[17]['website'] 	= "http://www.e-pay.com.my";
$gatway[17]['callback'] 	= "no";
$gatway[17]['function'] = "gateway_epay";
$gatway[17]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_epay', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'epay Email', 'type' => 'text', 'fieldname' => 'epay_mid'), 
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_epay_name', 'default' => 'Pay Now Using ePay'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_epay_icon' ),

'5' => array('name' => 'Merchant Number', 'type' => 'text', 'fieldname' => 'epay_merchantnumber' ),
'6' => array('name' => 'Currency', 'type' => 'text', 'fieldname' => 'epay_currency' ),
'7' => array('name' => 'epay_md5key', 'type' => 'text', 'fieldname' => 'epay_md5key' ),
'8' => array('name' => 'epay_callback', 'type' => 'text', 'fieldname' => 'epay_callback' ),
'9' => array('name' => 'epay_authmail', 'type' => 'text', 'fieldname' => 'epay_authmail' ),
'10' => array('name' => 'epay_authsms', 'type' => 'text', 'fieldname' => 'epay_authsms' ),
'11' => array('name' => 'epay_group', 'type' => 'text', 'fieldname' => 'epay_group' ),
'12' => array('name' => 'epay_splitpayment', 'type' => 'text', 'fieldname' => 'epay_splitpayment' ),
'13' => array('name' => 'epay_addfee', 'type' => 'text', 'fieldname' => 'epay_addfee' ),

);

$gatway[18]['name'] 	= "Realex Setup";
$gatway[18]['logo'] 		= "releax.png";
$gatway[18]['website'] 	= "http://www.realexpayments.com";
$gatway[18]['callback'] 	= "no";
$gatway[18]['function'] = "gateway_realex";
$gatway[18]['fields'] 	= array(
	'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_realex', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
	'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_realex_name', 'default' => 'Pay Now Using Realex'), 						
	'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_realex_icon' ),
	'5' => array('name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'realex_mid' ),
	'6' => array('name' => 'Secret Key', 'type' => 'text', 'fieldname' => 'realex_secret' ),
	'7' => array('name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'realex_currency' ),
);

$gatway[19]['name'] 	= "eWay UK Hosted";
$gatway[19]['logo'] 		= "eway.png";
$gatway[19]['website'] 	= "http://www.eway.co.uk";
$gatway[19]['callback'] 	= "no";
$gatway[19]['function'] = "gateway_eway_uk";
$gatway[19]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_eway_uk', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_eway_uk_name', 'default' => 'Pay Now Using eWay'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_eway_uk_icon' ),
'5' => array('name' => 'Customer ID', 'type' => 'text', 'fieldname' => 'eway_uk_cid' ),
'6' => array('name' => 'Username', 'type' => 'text', 'fieldname' => 'eway_uk_username' ),
'7' => array('name' => 'Company Name', 'type' => 'text', 'fieldname' => 'eway_uk_company' ),
'8' => array('name' => 'Callback Page', 'type' => 'text', 'fieldname' => 'eway_uk_callback' ),
);

$gatway[20]['name'] 	= "eWay NZ Hosted";
$gatway[20]['logo'] 		= "eway.png";
$gatway[20]['website'] 	= "http://www.eway.co.nz";
$gatway[20]['callback'] = "no";
$gatway[20]['function'] = "gateway_eway_nz";
$gatway[20]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_eway_nz', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_eway_nz_name', 'default' => 'Pay Now Using eWay'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_eway_nz_icon' ),
'5' => array('name' => 'Customer ID', 'type' => 'text', 'fieldname' => 'eway_nz_cid' ),
'6' => array('name' => 'Username', 'type' => 'text', 'fieldname' => 'eway_nz_username' ),
'7' => array('name' => 'Company Name', 'type' => 'text', 'fieldname' => 'eway_nz_company' ),
'8' => array('name' => 'Callback Page', 'type' => 'text', 'fieldname' => 'eway_nz_callback' ),
); 

/*$gatway[21]['name'] 	= "AliPay (Chinese Gateway)";
$gatway[21]['function'] = "gateway_alipay";
$gatway[21]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_alipay', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_alipay_name', 'default' => 'Pay Now Using Alipay'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_alipay_icon' ),

'5' => array('name' => 'Partner ID', 'type' => 'text', 'fieldname' => 'alipay_pid' ),
'6' => array('name' => 'Security Code', 'type' => 'text', 'fieldname' => 'alipay_code' ),
'7' => array('name' => 'Email', 'type' => 'text', 'fieldname' => 'alipay_email' ),
'8' => array('name' => 'Callback Page', 'type' => 'text', 'fieldname' => 'alipay_callback' ),
); */


$gatway[22]['name'] 	= "Money Bookers";
$gatway[22]['logo'] 		= "moneyb.png";
$gatway[22]['website'] 	= "http://www.moneybookers.com";
$gatway[22]['callback'] = "no";
$gatway[22]['function'] = "gateway_moneybookers";
$gatway[22]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_moneybookers', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_moneybookers_name', 'default' => 'Pay Now Using Moneybookers'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_moneybookers_icon' ),
'5' => array('name' => 'Account Email', 'type' => 'text', 'fieldname' => 'moneybookers_email' ),
'6' => array('name' => 'Callback URL', 'type' => 'text', 'fieldname' => 'moneybookers_callback' ),
 
); 


$gatway[23]['name'] 	= "MonsterPay Setup";
$gatway[23]['logo'] 		= "monster.png";
$gatway[23]['website'] 	= "http://www.monsterpay.com";
$gatway[23]['callback'] = "no";
$gatway[23]['function'] = "gateway_monsterpay";
$gatway[23]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_monsterpay', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'monsterpay_mid'), 
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_monsterpay_name', 'default' => 'Pay Now Using MonsterPay'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_monsterpay_icon' ),
'5' => array('name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'monsterpay_currency' ),
);

$gatway[24]['name'] 	= "Setcom Setup";
$gatway[24]['logo'] 		= "setcom.png";
$gatway[24]['website'] 	= "http://www.setcom.com";
$gatway[24]['callback'] = "no";
$gatway[24]['function'] = "gateway_setcom";
$gatway[24]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_setcom', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'Merchant ID', 'type' => 'text', 'fieldname' => 'setcom_mid'), 
'3' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_setcom_name', 'default' => 'Pay Now Using Setcom'), 						
'4' => array('name' => 'Display Icon', 'type' => 'text', 'fieldname' => 'gateway_setcom_icon' ),

);


$gatway[25]['name'] 	= "PayTrace Setup";
$gatway[25]['logo'] 		= "paytrace.png";
$gatway[25]['website'] 	= "https://paytrace.com";
$gatway[25]['callback'] = "no";
$gatway[25]['function'] = "gateway_paytrace";
$gatway[25]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox', 'fieldname' => 'gateway_paytrace', 'list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'PayTrace Username', 'type' => 'text', 'fieldname' => 'paytrace_u'), 
'3' => array('name' => 'PayTrace Password', 'type' => 'text', 'fieldname' => 'paytrace_p'), 
'4' => array('name' => 'Callback Page', 'type' => 'text', 'fieldname' => 'paytrace_callback'), 

);

 

/*$gatway[27]['name'] 	= "CardSave Setup";
$gatway[27]['logo'] 		= "cardsave.png";
$gatway[27]['website'] 	= "http://www.cardsave.net";
$gatway[27]['function'] 	= "gateway_cardsave";
$gatway[27]['callback'] 	= "no";
$gatway[27]['fields'] 	= array(
'1' => array('name' => 'Enable Gateway', 'type' => 'listbox','fieldname' => 'gateway_cardsave','list' => array('yes'=>'Enable','no'=>'Disable')),
'2' => array('name' => 'MerchantID', 'type' => 'text', 'fieldname' => 'gateway_cardsave_mID'),
'3' => array('name' => 'PreSharedKey', 'type' => 'text', 'fieldname' => 'gateway_cardsave_mKEY'),
'4' => array('name' => 'Password', 'type' => 'text', 'fieldname' => 'gateway_cardsave_mP'),
'5' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_cardsave_name', 'default' => 'Pay Now With CardSave') ,
'6' => array('name' => 'Callback Page URL', 'type' => 'text', 'fieldname' => 'gateway_cardsave_callback' ) ,
'7' => array('name' => 'Currency Code', 'type' => 'text', 'fieldname' => 'gateway_cardsave_currency', 'default' => '826' ),
);*/


$gatway[28]['name'] 	= "TotalWebSolutions";
$gatway[28]['logo'] 		= "totalw.png";
$gatway[28]['website'] 	= "http://www.totalwebsolutions.com/";
$gatway[28]['function'] 	= "gateway_totalwebsolutions";
$gatway[28]['callback'] 	= "no";
$gatway[28]['fields'] 	= array(

'1' => array('name' => 'Enable Gateway', 'type' => 'listbox','fieldname' => 'gateway_totalwebsolutions','list' => array('yes'=>'Enable','no'=>'Disable') ),
'2' => array('name' => 'Customer ID', 'type' => 'text', 'fieldname' => 'gateway_totalwebsolutions_ID'),
'3' => array('name' => 'Currency', 'type' => 'listbox', 'fieldname' => 'gateway_totalwebsolutions_currency' ,'list' => 
array('826'=>'Pound Sterling','978'=>'Euro', '840'=>'US Dollar', '036'=>'Australian Dollar', '124'=>'Canadian Dollar', '208'=>'Danish Krone',  '344'=>'Hong Kong Dollar', '392'=>'Japanese Yen', '578'=>'Norwegian Krone', '682'=>'Saudi Arabian Ryal',
'752' => 'Swedish Krone',  '756' => 'Swiss Franc')), 
'4' => array('name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_totalwebsolutions_name', 'default' => 'Pay Now With totalwebsolutions') ,
'5' => array('name' => 'Callback Page URL', 'type' => 'text', 'fieldname' => 'gateway_totalwebsolutions_callback' ) ,
 
);

$gatway[29]['name'] 	= "Bank Transfer";
$gatway[29]['logo'] 		= "bank.png";
$gatway[29]['function'] 	= "gateway_bank";
$gatway[29]['callback'] 	= "no";
$gatway[29]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_bank',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
							'2' => array(
											'name' => 'Bank/Payment Information <br><br><small>(tell the user how/where/when you want them to pay you here)</small>', 'type' => 'textarea', 'fieldname' => 'bank_info'
										   ),
							'3' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_bank_name', 'default' => 'Pay Now with Bank Transfer'
										   ) 

);


$gatway[30]['name'] 	= "Blank Payment Form";
$gatway[30]['logo'] 		= "blank.jpg";
$gatway[30]['function'] 	= "gateway_blank_form";
$gatway[30]['callback'] 	= "no";
$gatway[30]['fields'] 	= array(
							'1' => array(
											'name' => 'Enable Gateway', 
											'type' => 'listbox', 
											'fieldname' => 'gateway_blank_form',
											'list' => array(
												'yes'=>'Enable','no'=>'Disable',
											)
										   ),
							
						 '2' => array(
											'name' => 'Callback URL', 'type' => 'text', 'fieldname' => 'gateway_blank_form_callback',
										   ), 
							'3' => array(
											'name' => 'Display Name', 'type' => 'text', 'fieldname' => 'gateway_blank_form_name', 'default' => 'Pay Now'
										   ), 
										   
										   '4' => array(
											'name' => 'Admin Email (seperate with comma)', 'type' => 'text', 'fieldname' => 'gateway_blank_form_email', 'default' => ''
										   ) 
										   
										   
										   
										   
										   

);



// ---------------------------- GATEWAY FIELD CODE ------------------------

 
function MakeField($type, $name, $value, $list="", $default=""){

if($value ==""){ $value = $default; }
	switch($type){
	
		case "checkbox": { return  "<input type='checkbox' class='checkbox' name='".$name."' value='".$value."'> "; } break;
	
		case "text": { return  "<input type='text' name='adminArray[".$name."]' value='".$value."' class='ppt-forminput'>"; } break;

		case "textarea": { return "<textarea name='adminArray[".$name."]' type='text' class='ppt-forminput' style='width:100%; height:150px;'>".stripslashes($value)."</textarea>"; } break;


		case "listbox": { 

			$r ="<select name='adminArray[".$name."]' class='ppt-forminput'>";
			foreach($list as $key => $val){
				if($value==$key){ $sel="selected"; }else{ $sel=""; }
				$r .="<option value='".$key."' ".$sel.">".$val."</option>";
			}
			$r .="</select>";
			return $r;

		} break;

	}

}

function MakePayButton($link){

global $PPT;

$STRING = '<a href="'.$link.'" class="button gray right" style="min-width:100px;">
				
				'.$PPT->_e(array('button','21')) .' <img src="'.get_template_directory_uri().'/PPT/img/button/locked.png" />
			</a>';
return $STRING;
}

// ---------------------------- GATEWAY CODE ------------------------

function gateway_paypal($data=""){

	global $wpdb;
 
	$gatewaycode = "";	
	

	$gatewaycode .= '<form method="post" action="https://www.paypal.com/cgi-bin/webscr" name="checkout_paypal">';

	if(isset($_POST['rec']) && $_POST['rec'] == 1){
	
		if(isset($GLOBALS['freetrialperiod']) && strlen($GLOBALS['freetrialperiod']) > 0){
			$gatewaycode .= '<input type="hidden" name="a1" value="0">
			<input type="hidden" name="p1" value="'.$GLOBALS['freetrialperiod'].'">
			<input type="hidden" name="t1" value="D">';
		}	

		$gatewaycode .= '<input type="hidden" name="cmd" value="_xclick-subscriptions">
		<input type="hidden" name="a3" value="'.$data['price']['total'].'">';

		if(!isset($_POST['rec_days'])){
				$gatewaycode .= '<input type="hidden" name="p3" value="1">
				<input type="hidden" name="t3" value="M">
				<input type="hidden" name="src" value="1">
				<input type="hidden" name="sra" value="1">';
		}else{

			if($_POST['rec_days'] < 8){

			$gatewaycode .= '<input type="hidden" name="a3" value="'.$data['price']['total'].'">		
			<input type="hidden" name="p3" value="'.$_POST['rec_days'].'">
			<input type="hidden" name="t3" value="D">
			<input type="hidden" name="src" value="1">
			<input type="hidden" name="sra" value="1">';

			}elseif($_POST['rec_days'] < 30){

			$numweeks = $_POST['rec_days']/7;
			$gatewaycode .= '<input type="hidden" name="a3" value="'.$data['price']['total'].'">
			<input type="hidden" name="p3" value="'.$numweeks.'">
			<input type="hidden" name="t3" value="W">
			<input type="hidden" name="src" value="1">
			<input type="hidden" name="sra" value="1">';

			}elseif($_POST['rec_days'] < 370){

			$nummonths = $_POST['rec_days']/30;							 							  	
			$gatewaycode .= '<input type="hidden" name="a3" value="'.$data['price']['total'].'">	
			<input type="hidden" name="p3" value="'.$nummonths.'">	
			<input type="hidden" name="t3" value="M">
			<input type="hidden" name="src" value="1">
			<input type="hidden" name="sra" value="1">';		
			}
		}

		
	}else{
		$gatewaycode .= '<input type="hidden" name="cmd" value="_xclick">';
	}
	
	$CURRENCYCODE =  get_option('paypal_currency');
	
	if(isset($GLOBALS['currency_code']) && strlen($GLOBALS['currency_code']) > 1 ){ $CURRENCYCODE = $GLOBALS['currency_code']; } 

	$gatewaycode .= '
	<input type="hidden" name="return" value="'.get_option('paypal_return').'?order_id='.$data['orderid'].'">
	<input type="hidden" name="cancel_return" value="'.get_option('paypal_cancel').'">
	<input type="hidden" name="notify_url" value="'.get_option('paypal_notify').'">';
	
	if(strtolower(PREMIUMPRESS_SYSTEM) == "shopperpress"){
	
		$items = explode(",",$data['description']);
		
		if(is_array($items)){ 
		
			$i=1;
			foreach($items as $item){
			
				$a = explode("[",$item);
				if(isset($a[1])){
				$isCart=true;
				
				$b = explode(" ",trim(substr(str_replace("x","",$a[0]),0,3)));
			 
				$gatewaycode .= 
				'<input type="hidden" name="item_name_'.$i.'" value="'.trim(strip_tags(substr(str_replace('"',"",$a[0]),3))).'">
				<input type="hidden" name="amount_'.$i.'" value="'.trim(substr($a[1],0,-1)).'">
				<input type="hidden" name="quantity_'.$i.'" value="'.$b[0].'">';
				$i++;
				}else{
				$gatewaycode .= '<input type="hidden" name="item_name" value="'.$data['description'].'">
				<input type="hidden" name="amount" value="'.$data['price']['total'].'">';
				}
			}
		
		}else{
		$gatewaycode .= '<input type="hidden" name="item_name" value="'.strip_tags($data['description']).'">';
		}
		
		if(isset($_POST['form']['shipping'])){
		
		$gatewaycode .= '<input type="hidden" name="shipping_1" value="'.trim(round($_POST['form']['shipping'],2)).'">';
		}
		if(isset($_POST['form']['tax'])){
		$gatewaycode .= '<input type="hidden" name="tax_cart" value="'.trim($_POST['form']['tax']).'">';
		}
		if(isset($_POST['form']['weight'])){
		$gatewaycode .= '<input type="hidden" name="weight_cart" value="'.trim($_POST['form']['weight']).'">';
		}
		if(isset($_POST['form']['discount']) && strlen($_POST['form']['discount']) > 0){
		$gatewaycode .= '<input type="hidden" name="discount_amount_cart" value="'.trim($_POST['form']['discount']).'">';
		}		
		
		
		if(isset($isCart)){
		$gatewaycode = str_replace("_xclick","_cart",$gatewaycode);
		$gatewaycode .= '<input type="hidden" name="upload" value="1">';
		}
	
	}else{
	
	if(isset($GLOBALS['packageName']) && strlen($GLOBALS['packageName']) > 1){ $data['description'] = $GLOBALS['packageName']; } // quick fix
	
	$gatewaycode .= '<input type="hidden" name="item_name" value="'.strip_tags($data['description']).'">
	<input type="hidden" name="amount" value="'.$data['price']['total'].'">';
	}
	
	$CURRENCYCODE = str_replace("1","",$CURRENCYCODE);
	
	$gatewaycode .= '<input type="hidden" name="item_number" value="'.$data['orderid'].'">
	<input type="hidden" name="business" value="'.get_option('paypal_email').'">
	<input type="hidden" name="currency_code" value="'.$CURRENCYCODE.'">
	<INPUT TYPE="hidden" name="charset" value="utf-8">
	<input type="hidden" name="custom" value="'.$data['orderid'].'">
	'.MakePayButton('javascript:document.checkout_paypal.submit();').'
	 

	</form>';

	return $gatewaycode;

}

function gateway_worldpay($data=""){

	global $wpdb;

	$gatewaycode = "";

	$gatewaycode = '<form name="checkout_worldpay" target="_top" method="post" action="https://select.worldpay.com/wcc/purchase">	
	<input type="hidden" name="amount" value="'.$data['price']['total'].'" />
	<input type="hidden" name="instId" value="'.get_option('worldpay_instId').'" />
	<input type="hidden" name="accId1" value="'.get_option('worldpay_accId1').'" />
	<input type="hidden" name="cartId" value="'.$data['orderid'].'" />
	<input type="hidden" name="desc" value="'.strip_tags($data['description']).'" />
	<input type="hidden" name="currency" value="'.get_option('worldpay_currency').'" />
	<input name="testMode" value="'.get_option('worldpay_testmode').'" type="hidden" />
'.MakePayButton('javascript:document.checkout_worldpay.submit();').'
	 

	</form>';

	return $gatewaycode;

}

function gateway_bank($data=""){

	global $wpdb;


	$gatewaycode = ''.MakePayButton('javascript:location.href=\''.get_option('bank_link').'\'').'';

	return $gatewaycode;

}

function gateway_google($data=""){

	global $wpdb;


	$gatewaycode = "";

	$gatewaycode = '<form method="post"  action="https://checkout.google.com/api/checkout/v2/checkoutForm/Merchant/'.get_option('google_merchant').'" name="checkout_google" accept-charset="utf-8">

  <input type="hidden" name="item_name_1" value="'.$data['orderid'].'"/>
  <input type="hidden" name="item_description_1" value="'.strip_tags($data['description']).'"/>
  <input type="hidden" name="item_quantity_1" value="1"/>
  <input type="hidden" name="item_price_1" value="'.$data['price']['total'].'"/>
  <input type="hidden" name="item_currency_1" value="'.get_option('google_currency').'"/>
 <input type="hidden" name="item_currency_1" value="'.get_option('google_currency').'"/>
 
  <input type="hidden" name="checkout-flow-support.merchant-checkout-flow-support.continue-shopping-url" value="'.get_option('gateway_google_callback').'?order_id='.$data['orderid'].'"/>
  <input type="hidden" name="continue_url" value="'.get_option('gateway_google_callback').'?order_id='.$data['orderid'].'"/>
 
 
	  <input type="hidden" name="_charset_"/>
'.MakePayButton('javascript:document.checkout_google.submit();').'
 
	
	  </form>';

	return $gatewaycode;

}

function gateway_custom($data=""){

	global $wpdb;


	// CUSTOM REPLACE
	$PaymentButton = str_replace("(orderid)",$data['orderid'],get_option('custom_data'));
	$PaymentButton = str_replace("(amount)",$data['price']['total'],$PaymentButton);
	$PaymentButton = str_replace("(description)",strip_tags($data['description']),$PaymentButton);
	$PaymentButton = str_replace('\"','"',$PaymentButton);
	$PaymentButton = str_replace('(city)',strip_tags($data['billing']['city']),$PaymentButton);
	$PaymentButton = str_replace('(email)',strip_tags($data['billing']['email']),$PaymentButton);
	$PaymentButton = str_replace('(fname)',strip_tags($data['billing']['fname']),$PaymentButton);
	$PaymentButton = str_replace('(lname)',strip_tags($data['billing']['lname']),$PaymentButton);
	$PaymentButton = str_replace('(address1)',strip_tags($data['billing']['address1']),$PaymentButton);
	$PaymentButton = str_replace('(address2)',strip_tags($data['billing']['address2']),$PaymentButton);
	$PaymentButton = str_replace('(phone)',strip_tags($data['billing']['phone']),$PaymentButton);
	$PaymentButton = str_replace('(country)',strip_tags($data['billing']['country']),$PaymentButton);


	$gatewaycode = "";

	$gatewaycode = '<form method="POST" action="'.get_option('custom_form').'" name="checkout_custom">'.$PaymentButton.'
'.MakePayButton('javascript:document.checkout_custom.submit();').'
 
	
	  </form>';

	return $gatewaycode;

}


function gateway_authorize($data=""){

	global $wpdb;

	$gatewaycode = "";

	$gatewaycode = '<form name="gateway_authorize" target="_top" method="post" action="https://secure.authorize.net/gateway/transact.dll">';

	$gatewaycode .='
	<input type="hidden" name="x_amount" value="'.$data['price']['total'].'" >
	<input type="hidden" name="x_login" value="'.get_option('authorize_loginID').'">
	<input type="hidden" name="x_description" value="'.strip_tags($data['description']).'">
	<input type="hidden" name="x_cust_ID" value="'.$data['orderid'].'">
	<input type="hidden" name="x_receipt_link_url" value="'.get_option('authorize_callback').'?order_id='.$data['orderid'].'">	
	
	<input type="hidden" name="x_relay_url" value="'.get_option('authorize_callback').'?order_id='.$data['orderid'].'">	
	<input type="hidden" name="x_relay_always" value="true">
	<input type="hidden" name="x_relay_response" value="true"> 
	
	<input type="hidden" name="x_show_form" value="PAYMENT_FORM">';

	// create figure print for authoize.net
	$loginID			= get_option('authorize_loginID');
	$transactionKey 	= get_option('authorize_transactionID');
	$sequence			= rand(1, 1000);
	$timeStamp			= time ();
				
	if( phpversion() >= '5.1.2' )
	{	
	$fingerprint = hash_hmac("md5", $loginID . "^" . $sequence . "^" . $timeStamp . "^" . $data['price']['total'] . "^", $transactionKey); 
	}
	else 
	{ 
	$fingerprint = bin2hex(mhash(MHASH_MD5, $loginID . "^" . $sequence . "^" . $timeStamp . "^" . $data['price']['total'] . "^", $transactionKey)); 
	}
 
	 
	$gatewaycode .='<input type="hidden" name="amount" value="'.$data['price']['total'].'" >
	<input type="hidden" name="x_fp_sequence" value="'.$sequence.'">
	<input type="hidden" name="x_fp_hash" value="'.$fingerprint.'"> 
	<input type="hidden" name="x_fp_timestamp" value="'.$timeStamp.'">
	
	'.MakePayButton('javascript:document.gateway_authorize.submit();').'
	
 

	</form>';

	return $gatewaycode;

}

function gateway_protx($data=""){

	global $wpdb;
	
	//if(isset($_POST['form'])){ $data['billing'] = $_POST['form']; }
 
	$gatewaycode = '<form name="gateway_protx" target="_top" method="post" action="https://live.sagepay.com/gateway/service/vspform-register.vsp">';

	$gatewaycode .='<input type="hidden" name="VPSProtocol" value="2.23">
	<input type="hidden" name="TxType" value="PAYMENT">
	<input type="hidden" name="Vendor" value="'.get_option('protx_vendor').'">
	<input type="hidden" name="navigate" value="" />';

	/** Okay, build the crypt field for Form using the information in our session **
	*** First we need to generate a unique VendorTxCode for this transaction **
	*** We're using VendorName, time stamp and a random element.  You can use different methods if you wish **
	*** but the VendorTxCode MUST be unique for each transaction you send to Server **/
		
		$intRandNum = rand(0,32000)*rand(0,32000);
		$strVendorTxCode= get_option('protx_vendor') . $intRandNum;

	// Now to build the Form crypt field.  For more details see the Form Protocol 2.23 
	$strPost="VendorTxCode=" . $strVendorTxCode; /** As generated above **/
	$strPost=$strPost . "&Amount=" . $data['price']['total']; // Formatted to 2 decimal places with leading digit
	$strPost=$strPost . "&Currency=" . get_option('protx_currency');
	// Up to 100 chars of free format description
	$strPost=$strPost . "&Description=Online Order From " . get_option('protx_vendor');
	
	/* The SuccessURL is the page to which Form returns the customer if the transaction is successful 
	** You can change this for each transaction, perhaps passing a session ID or state flag if you wish */
	$strPost=$strPost . "&SuccessURL=" . get_option('protx_success').'?order_id='.$data['orderid'];
	
	/* The FailureURL is the page to which Form returns the customer if the transaction is unsuccessful
	** You can change this for each transaction, perhaps passing a session ID or state flag if you wish */
	$strPost=$strPost . "&FailureURL=" . get_option('protx_fail');
	
	// This is an Optional setting. Here we are just using the Billing names given.
	$strPost=$strPost . "&CustomerName=" . $_POST['form']['first_name'] . " " . $_POST['form']['last_name'];
 
	 $ne = array('first_name','last_name','address','city');
	 foreach($ne as $val){
	  if($_POST['form'][$val] == ""){ $_POST['form'][$val] = "."; }
	 }
	if($_POST['form']['postcode'] == ""){$_POST['form']['postcode']="YO124HY"; }
 
	// Billing Details:
	$strPost=$strPost . "&BillingFirstnames=" . $_POST['form']['first_name'];
	$strPost=$strPost . "&BillingSurname=" . $_POST['form']['last_name'];
	$strPost=$strPost . "&BillingAddress1=" . $_POST['form']['address'];
	 
	$strPost=$strPost . "&BillingCity=" . $_POST['form']['city'];
	$strPost=$strPost . "&BillingPostCode=". $_POST['form']['postcode'];
	$strPost=$strPost . "&BillingCountry=GB"; //$data['billing']['country']
	
	// Delivery Details:
	$strPost=$strPost . "&DeliveryFirstnames=" . $_POST['form']['first_name'];
	$strPost=$strPost . "&DeliverySurname=" . $_POST['form']['last_name'];
	$strPost=$strPost . "&DeliveryAddress1=" . $_POST['form']['address'];
	$strPost=$strPost . "&DeliveryCity=" . $_POST['form']['city'];
	$strPost=$strPost . "&DeliveryPostCode=". $_POST['form']['postcode'];
	$strPost=$strPost . "&DeliveryCountry=GB" ; //$data['billing']['country']
	
	$strPost=$strPost . "&Basket=" . $strBasket; // As created above 
	
	// For charities registered for Gift Aid, set to 1 to display the Gift Aid check box on the payment pages
	$strPost=$strPost . "&AllowGiftAid=0";
 		
	/* Allow fine control over 3D-Secure checks and rules by changing this value. 0 is Default 
	** It can be changed dynamically, per transaction, if you wish.  See the Form Protocol document */
	$strPost=$strPost . "&Apply3DSecure=0";
	// Encrypt the plaintext string for inclusion in the hidden field
 
	$strCrypt = base64Encode(SimpleXor($strPost,get_option('protx_key')));

	$gatewaycode .='<input type="hidden" name="Crypt" value="'.$strCrypt.'" >

'.MakePayButton('javascript:document.gateway_protx.submit();').'

	 

	</form>';

	return $gatewaycode;


}

function simpleXor($InString, $Key) {
  // Initialise key array
  $KeyList = array();
  // Initialise out variable
  $output = "";
  
  // Convert $Key into array of ASCII values
  for($i = 0; $i < strlen($Key); $i++){
    $KeyList[$i] = ord(substr($Key, $i, 1));
  }

if(strlen($InString) > 1){
  // Step through string a character at a time
  for($i = 0; $i < strlen($InString); $i++) {
    // Get ASCII code from string, get ASCII code from key (loop through with MOD), XOR the two, get the character from the result
    // % is MOD (modulus), ^ is XOR
    $output.= chr(ord(substr($InString, $i, 1)) ^ ($KeyList[$i % strlen($Key)]));
  }
}
  // Return the result
  return $output;
}
 

/* Base 64 Encoding function **
** PHP does it natively but just for consistency and ease of maintenance, let's declare our own function **/

function base64Encode($plain) {
  // Initialise output variable
  $output = "";
  
  // Do encoding
  $output = base64_encode($plain);
  
  // Return the result
  return $output;
}

/* Base 64 decoding function **
** PHP does it natively but just for consistency and ease of maintenance, let's declare our own function **/

function base64Decode($scrambled) {
  // Initialise output variable
  $output = "";
  
  // Fix plus to space conversion issue
  $scrambled = str_replace(" ","+",$scrambled);
  
  // Do encoding
  $output = base64_decode($scrambled);
  
  // Return the result
  return $output;
}






function gateway_ccavenue($data=""){

	global $wpdb;

	$gatewaycode = "";

	$gatewaycode = '<form name="gateway_ccavenue" target="_top" method="post" action="https://www.ccavenue.com/shopzone/cc_details.jsp">';


	$Merchant_Id = get_option('ccavenue_merchantID');//This id(also User Id)  available at "Generate Working Key" of "Settings & Options" 
	$Amount = str_replace(",","",$data['price']['total']);// $data['price']['total'] ;//your script should substitute the amount in the quotes provided here
	$Order_Id = $data['orderid'];//your script should substitute the order description in the quotes provided here
	$Redirect_Url = get_option('ccavenue_url') ;//your redirect URL where your customer will be redirected after authorisation from CCAvenue

	$WorkingKey = get_option('ccavenue_key') ;//put in the 32 bit alphanumeric key in the quotes provided here.Please note that get this key ,login to your CCAvenue merchant account and visit the "Generate Working Key" section at the "Settings & Options" page. 
	$Checksum = getCheckSum($Merchant_Id,$Amount,$Order_Id ,$Redirect_Url,$WorkingKey);

	$gatewaycode .='
	<input type=hidden name=Merchant_Id value="'.get_option('ccavenue_merchantID').'">
	<input type=hidden name=Amount value="'.str_replace(",","",$data['price']['total']).'">
	<input type=hidden name=Order_Id value="'.$data['orderid'].'">
	<input type=hidden name=Redirect_Url value="'.get_option('ccavenue_url').'">
	<input type=hidden name=Checksum value="'.$Checksum.'">
	<input type="hidden" name="billing_cust_name" value="'.$data['billing']['fname'].' '.$data['billing']['lname'].'"> 
	<input type="hidden" name="billing_cust_address" value="'.$data['billing']['address'].'"> 
	<input type="hidden" name="billing_cust_country" value="'.$data['billing']['country'].'"> 
	<input type="hidden" name="billing_cust_state" value="'.$data['billing']['state'].'"> 
	<input type="hidden" name="billing_zip" value="'.$data['billing']['postcode'].'"> 
	<input type="hidden" name="billing_cust_tel" value="'.$data['billing']['phone'].'"> 
	<input type="hidden" name="billing_cust_email" value="'.$data['billing']['email'].'"> 
	<input type="hidden" name="delivery_cust_name" value="'.$data['billing']['fname'].'"> 
	<input type="hidden" name="delivery_cust_address" value="'.$data['billing']['address'].'"> 
	<input type="hidden" name="delivery_cust_country" value="'.$data['billing']['country'].'"> 
	<input type="hidden" name="delivery_cust_state" value="'.$data['billing']['state'].'"> 
	<input type="hidden" name="delivery_cust_tel" value="'.$data['billing']['phone'].'"> 
	<input type="hidden" name="delivery_cust_notes" value=""> 
	<input type="hidden" name="Merchant_Param" value=""> 
	<input type="hidden" name="billing_cust_city" value="'.$data['billing']['city'].'"> 
	<input type="hidden" name="billing_zip_code" value="'.$data['billing']['postcode'].'"> 
	<input type="hidden" name="delivery_cust_city" value="'.$data['billing']['city'].'"> 
	<input type="hidden" name="delivery_zip_code" value="'.$data['billing']['postcode'].'">  
	
	'.MakePayButton('javascript:document.gateway_ccavenue.submit();').'


	</form>';

	return $gatewaycode;

}
 function getchecksum($MerchantId,$Amount,$OrderId ,$URL,$WorkingKey)
{
	$str ="$MerchantId|$OrderId|$Amount|$URL|$WorkingKey";
	$adler = 1;
	$adler = adler32($adler,$str);
	return $adler;
}

function adler32($adler , $str)
{
	$BASE =  65521 ;

	$s1 = $adler & 0xffff ;
	$s2 = ($adler >> 16) & 0xffff;
	for($i = 0 ; $i < strlen($str) ; $i++)
	{
		$s1 = ($s1 + Ord($str[$i])) % $BASE ;
		$s2 = ($s2 + $s1) % $BASE ;
			//echo "s1 : $s1 <br /> s2 : $s2 <br />";

	}
	return leftshift($s2 , 16) + $s1;
}

function leftshift($str , $num)
{

	$str = DecBin($str);

	for( $i = 0 ; $i < (64 - strlen($str)) ; $i++)
		$str = "0".$str ;

	for($i = 0 ; $i < $num ; $i++) 
	{
		$str = $str."0";
		$str = substr($str , 1 ) ;
		//echo "str : $str <br />";
	}
	return cdec($str) ;
}

function cdec($num)
{

	for ($n = 0 ; $n < strlen($num) ; $n++)
	{
	   $temp = $num[$n] ;
	   $dec =  $dec + $temp*pow(2 , strlen($num) - $n - 1);
	}

	return $dec;
}


function gateway_alertpay($data=""){

	global $wpdb;

	$gatewaycode = "";

	$gatewaycode = '<form name="gateway_alertpay" target="_top" method="post" action="https://secure.payza.com/checkout">';


$gatewaycode .='<input type="hidden" name="ap_merchant" value="'.get_option('alertpay_merchantID').'" >
<input type="hidden" name="ap_amount" value="'.$data['price']['total'].'">
<input type="hidden" name="ap_itemname" value=" ORDER ID: '.$data['orderid'].'"> 
<input type="hidden" name="ap_description" value="'.strip_tags($data['description']).'" >
<input type="hidden" name="ap_returnurl" value="'.get_option('alertpay_success').'?order_id='.$data['orderid'].'">
<input type="hidden" name="ap_cancelurl" value="'.get_option('alertpay_fail').'"> 
<input type="hidden" name="ap_itemcode" value="'.$data['orderid'].'"> 
<input type="hidden" name="ap_quantity" value="1" >
<input type="hidden" name="ap_currency" value="'.get_option('alertpay_currency').'">
<input type="hidden" name="ap_test" value="0"> 
<input type="hidden" name="ap_purchasetype" value="service"> 

	'.MakePayButton('javascript:document.gateway_alertpay.submit();').'
 

	</form>';

	return $gatewaycode;

}


function eway_fetch_data($string, $start_tag, $end_tag)
		{
			$position = stripos($string, $start_tag);  
			$str = substr($string, $position);  		
			$str_second = substr($str, strlen($start_tag));  		
			$second_positon = stripos($str_second, $end_tag);  		
			$str_third = substr($str_second, 0, $second_positon);  		
			$fetch_data = trim($str_third);		
			return $fetch_data; 
		}
		
		
		
function gateway_eWay($data=""){

	global $wpdb;

	$total = str_replace(".","",$data['price']['total']);
	if(strlen($total) == 3){ $total .=0; }
	if(strlen($total) == 1 || strlen($total) == 2){ $total .="00"; }
	$gatewaycode = "";
	
 
        $ewayurl ="?CustomerID=".get_option('eWay_customerID');
		$ewayurl.="&UserName=".get_option('eWay_username');
		$ewayurl.="&Amount=".number_format($data['price']['total'],2);
		$ewayurl.="&Currency=AUD";
		//$ewayurl.="&PageTitle=".$_POST['PageTitle'];
	    //$ewayurl.="&PageDescription=".$_POST['PageDescription'];
		//$ewayurl.="&PageFooter=".$_POST['PageFooter'];	
		$ewayurl.="&Language=EN";
		$ewayurl.="&CompanyName=".$data['billing']['company'];
		$ewayurl.="&CustomerFirstName=".$data['billing']['fname'];
	    $ewayurl.="&CustomerLastName=".$data['billing']['lname'];		
		$ewayurl.="&CustomerAddress=".$data['billing']['address'];
		$ewayurl.="&CustomerCity=".$data['billing']['city'];
		$ewayurl.="&CustomerState=".$data['billing']['state'];
		$ewayurl.="&CustomerPostCode=".$data['billing']['postcode'];
		$ewayurl.="&CustomerCountry=".$data['billing']['country'];		
		$ewayurl.="&CustomerEmail=".$data['billing']['email'];
		$ewayurl.="&CustomerPhone=".$data['billing']['phone'];		
		$ewayurl.="&InvoiceDescription=".strip_tags($data['description']);
		$ewayurl.="&CancelURL=".get_option('eWay_returnURL');
		$ewayurl.="&ReturnUrl=".get_option('eWay_returnURL').'?order_id='.$data['orderid'];
		//$ewayurl.="&CompanyLogo=".$_POST['CompanyLogo'];
		//$ewayurl.="&PageBanner=".$_POST['PageBanner'];
		$ewayurl.="&MerchantReference=".$data['orderid'];
		$ewayurl.="&MerchantInvoice=".$data['orderid'];
		$ewayurl.="&MerchantOption1="; 
		$ewayurl.="&MerchantOption2=";
		$ewayurl.="&MerchantOption3=";
		//$ewayurl.="&ModifiableCustomerDetails=".$_POST['ModDetails'];
			
	    $spacereplace = str_replace(" ", "%20", $ewayurl);	
	    $posturl="https://au.ewaygateway.com/Request/$spacereplace";	
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $posturl);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	 
		$response = curl_exec($ch);
	 
		
		$responsemode = eway_fetch_data($response, '<result>', '</result>');
	    $responseurl = eway_fetch_data($response, '<uri>', '</uri>');
 
		$gatewaycode = '<form method="post" name="gateway_eWay" action="'.$responseurl.'">';
	 
		$gatewaycode .=''.MakePayButton('javascript:document.gateway_eWay.submit();').'</form>';

	return $gatewaycode;

}


function gateway_bluepay($data=""){


$gatewaycode = '<form action="https://secure.bluepay.com/interfaces/bp10emu" method=POST name="gateway_bluepay"> 
	<input type=hidden name=MERCHANT value="demo"> 
	<input type=hidden name=TRANSACTION_TYPE value="AUTH"> 
	<input type=hidden name=REBILLING value="1"> 
	<input type=hidden name=REB_FIRST_DATE value="1 MONTH"> 
	<input type=hidden name=REB_EXPR value="1 MONTH"> 
	<input type=hidden name=REB_CYCLES value="11"> 
	<input type=hidden name=REB_AMOUNT value="5.00"> 
	<input type=hidden name=TAMPER_PROOF_SEAL value="????"> 
	<input type=hidden name=AMOUNT value="'.$data['price']['total'].'"> 
	<input type=hidden name=Order_ID value="'.$data['orderid'].'"> 
	<input type=hidden name=APPROVED_URL value="http://momandpop.com/goodpay.html"> 
	<input type=hidden name=DECLINED_URL value="http://momandpop.com/badpay.html"> 
	<input type=hidden name=MISSING_URL value="http://momandpop.com/error.html"> 
	<input type=hidden name=COMMENT value="SUBSCRIPTION TO WIDGET OF THE MONTH 
	CLUB, 1YR"> 
	 
	<table> 
	<tr><td>Card number</td><td><input type=text name=CC_NUM value=""></td></tr> 
	<tr><td>CVV2</td><td><input type=text name=CVCCVV2 value=""></td></tr> 
	<tr><td>Expiration Date</td><td><input type=text name=CC_EXPIRES value=""></td></tr> 
	<tr><td>NAME</td><td><input type=text name=NAME value=""></td></tr> 
	<tr><td>Address</td><td><input type=text name=Addr1 value=""></td></tr> 
	<tr><td>Address 2</td><td><input type=text name=Addr2></td></tr>> 
	<tr><td>City</td><td><input type=text name=CITY value=""></td></tr> 
	<tr><td>State</td><td><input type=text name=STATE value=""></td></tr> 
	<tr><td>Zipcode</td><td><input type=text name=ZIPCODE value=""></td></tr> 
	<tr><td>Phone</td><td><input type=text name=PHONE value=""></td></tr> 
	<tr><td>Email</td><td><input type=text name=EMAIL value=""></td></tr> 
	<tr><td colspan=2><input type=SUBMIT value="Test it." name=SUBMIT></td></tr> 
	</table> 

	'.MakePayButton('javascript:document.gateway_bluepay.submit();').'
		
 
	 
	</form>';
	
	return $gatewaycode;


}


function gateway_2checkout($data=""){

$gatewaycode ="<form action='https://www.2checkout.com/checkout/purchase' method='post' name='gateway_2checkout'>
<input type='hidden' name='sid' value='".get_option('2checkout_customerID')."' >
<input type='hidden' name='total' value='".str_replace(",","",$data['price']['total'])."' >
<input type='hidden' name='cart_order_id' value='".$data['orderid']."' >
<input type='hidden' name='id_type' value='1' >
<input type='hidden' name='sh_cost' value='0.00' >
<input type='hidden' name='c_prod' value='".strip_tags($data['description'])."' >
<input type='hidden' name='c_name' value='Product 10' >
<input type='hidden' name='c_description' value='".strip_tags($data['description'])."' >
<input type='hidden' name='c_price' value='1.00' >
<input type='hidden' name='x_receipt_link_url' value='".get_option('2checkout_returnURL')."?order_id=".$data['orderid']."' >



";

$gatewaycode .=  MakePayButton('javascript:document.gateway_2checkout.submit();').' </form>';

return $gatewaycode;


//get_option('2checkout_fail')
//get_option('2checkout_returnURL')

}

function gateway_payfast($data=""){

$gatewaycode = '<form action="https://www.payfast.co.za/eng/process" method="post" name="gateway_payfast">

<!-- Receiver Details -->
<input type="hidden" name="merchant_id" value="'.get_option('payfast_ID').'">
<input type="hidden" name="merchant_key" value="'.get_option('payfast_key').'">
<input type="hidden" name="return_url" value="'.get_option('payfast_return').'?order_id='.$data['orderid'].'">
<input type="hidden" name="cancel_url" value="'.get_option('payfast_fail').'">
<input type="hidden" name="notify_url" value="'.get_option('payfast_return').'">

<!-- Payer Details -->
<input type="hidden" name="name_first" value="'.$data['billing']['fname'].'">
<input type="hidden" name="name_last" value="'.$data['billing']['lname'].'">
<input type="hidden" name="email_address" value="'.$data['billing']['email'].'">

<!-- Transaction Details -->
<input type="hidden" name="m_payment_id" value="'.$data['orderid'].'">
<input type="hidden" name="amount" value="'.$data['price']['total'].'">
<input type="hidden" name="item_name" value="'.strip_tags($data['description']).'">
<input type="hidden" name="item_description" value="'.strip_tags($data['description']).'">

<!-- Transaction Options -->
<input type="hidden" name="email_confirmation" value="">

<!-- Security -->
<input type="hidden" name="signature" value="">';


$gatewaycode .= MakePayButton('javascript:document.gateway_payfast.submit();').'</form>';

return $gatewaycode;


}


function gateway_payweb($data=""){

    $PAYGATE_ID			= get_option('payweb_ID');
    $REFERENCE			= "Cart ID: ".$data['orderid'];
	
	$num = number_format($data['price']['total'],2, '.', ',');
	
    $AMOUNT				= str_replace(".","",str_replace(",","",$num));
    $CURRENCY			= "ZAR";
    $RETURN_URL			= get_option('payweb_return');
    $TRANSACTION_DATE	= gmstrftime("%Y-%m-%d %H:%M");
    $EMAIL 				= $data['billing']['email'];
    $encryption_key 	= get_option('payweb_key');

    $checksum_source 	= $PAYGATE_ID."|".$REFERENCE."|".$AMOUNT."|".$CURRENCY."|".$RETURN_URL."|".$TRANSACTION_DATE."|";
    $checksum_source 	.= $EMAIL."|";
    $checksum_source 	.= $encryption_key;
    $CHECKSUM 			= md5($checksum_source);
	
$gatewaycode = '<form action="https://www.paygate.co.za/paywebv2/process.trans" method="post" name="gateway_payweb">
<input type="hidden" name="AMOUNT" 		value="'.$AMOUNT.'">
<input type="hidden" name="CHECKSUM" 	value="'.$CHECKSUM.'">
<input type="hidden" name="EMAIL" 		value="'.$data['billing']['email'].'">
<input type="hidden" name="TRANSACTION_DATE" value="'.$TRANSACTION_DATE.'">
<input type="hidden" name="RETURN_URL" 	value="'.$RETURN_URL.'">
<input type="hidden" name="CURRENCY" 	value="'.$CURRENCY.'">
<input type="hidden" name="REFERENCE" 	value="'.$REFERENCE.'">
<input type="hidden" name="PAYGATE_ID" 	value="'.$PAYGATE_ID.'">';
$gatewaycode .= MakePayButton('javascript:document.gateway_payweb.submit();').' </form>';

return $gatewaycode;


}

function gateway_ideal($data=""){
 

require_once(TEMPLATEPATH.'/PPT/gateways/class_ideal.php');
$partner_id  = get_option('ideal_ID'); // Uw mollie partner ID
$iDEAL = new iDEAL_Payment ($partner_id);
//$iDEAL->setTestMode();
$bank_array = $iDEAL->getBanks();

if ($bank_array == false)
{
	echo '<p>Er is een fout opgetreden bij het ophalen van de banklijst: ', $iDEAL->getErrorMessage(), '</p>';
	exit;
}

?>
<form method="post" action="<?php echo get_option('ideal_return'); ?>">
<input type="hidden" name="customgateway" value="ideal" />
<input type="hidden" name="custom" value="<?php echo $data['orderid']; ?>" />
<input type="hidden" name="amount" value="<?php if(strpos($_POST['price']['total'], ",") === false ){ echo $_POST['price']['total']; }else{ $f = explode(",",$_POST['price']['total']); echo $f[0]; } ?>" />
<input type="hidden" name="desc" value="<?php echo strip_tags($data['description']); ?>" />
<select name="bank_id">
<option value=''>Kies uw bank</option>		
<?php foreach ($bank_array as $bank_id => $bank_name) { ?>
		<option value="<?php echo $bank_id ?>"><?php echo $bank_name ?></option>
<?php } ?>
</select>
<input type="submit" name="submit" value="Betaal via iDEAL" />
</form>

<?php
}


function gateway_paypalpro($data=""){ ?>
 

<form method="POST" action="<?php echo get_option('paypalpro_callback'); ?>">
<input type="hidden" name="customgateway" value="paypalpro" />

<input type="hidden" name="paymentType" value="instant" />
<input type="hidden" name="gateway" value="paypalpro" />
<input type="hidden" name="amount" value="<?php echo $data['price']['total']; ?>">
<input type="hidden" value="<?php echo $data['orderid']; ?>" name="paypal_order_id">


<?php if($_POST['rec'] == 1){  
 
	if($_POST['rec_days'] < 6){
	$pb = $_POST['rec_days'];
	$pp = "Day";		
	}elseif($_POST['rec_days'] < 30){	
	$pb = round($_POST['rec_days']/7);	
	$pp = "Week";		
	}elseif($_POST['rec_days'] < 364){	
	$pb = round($_POST['rec_days']/30);	
	$pp = "Month";
	}elseif($_POST['rec_days'] == 365){
	$pb=1;
	$pp = "Year";
	}
?>
<input type="hidden" value="<?php echo $pp; ?>" name="billingPeriod">
<input type="hidden" value="<?php echo $pb; ?>" name="billingFreq">

<?php }else{ ?>
<input type="hidden" value="0" name="recurring">
<?php }   ?>

<h3>Payment Details</h3>

<div class="full clearfix  box"> <br />
 
<p class="f_half left"> 
  <label class="col1">First Name:</label> <br />    
  <input  class="mid2" type=text size=30 maxlength=32 name="firstName" value="<?php echo $data['billing']['fname']; ?>"> 
</p>

<p class="f_half left"> 
        <label class="col1">Last Name:</label> 
        <input class="mid2"  type=text size=30 maxlength=32 name=lastName value="<?php echo $data['billing']['flname']; ?>">
</p>

<div class="clearfix"></div>

<p class="f_half left"> 
  <label class="col1">Card Type:</label> 
<span class="col2"><select  class="mid2" name=creditCardType onchange="javascript:generateCC(); return false;">
				<option value=Visa selected>Visa</option>
				<option value=MasterCard>MasterCard</option>
				<option value=Discover>Discover</option>
				<option value=Amex>American Express</option>
			</select></span>      
</p>

<p class="f_half left"> 
    <label class="col1">Card Number:</label> 
<span class="col2"><input  class="mid2" type=text size=19 maxlength=19 name="creditCardNumber"></span>    
</p>


<div class="clearfix"></div>

<p class="f_half left"> 
      <label class="col1">Expiration Date:</label>
<span class="col2"><select  class="mid2" name=expDateMonth>
				<option value=1>01</option>
				<option value=2>02</option>
				<option value=3>03</option>
				<option value=4>04</option>
				<option value=5>05</option>
				<option value=6>06</option>
				<option value=7>07</option>
				<option value=8>08</option>
				<option value=9>09</option>
				<option value=10>10</option>
				<option value=11>11</option>
				<option value=12>12</option>
			</select>
			<select  class="mid2" name=expDateYear>
				 
				<option value=2012>2012</option>
				<option value=2013>2013</option>
				<option value=2014>2014</option>
				<option value=2015>2015</option>
                <option value=2016>2016</option>
                <option value=2017>2017</option>
                <option value=2018>2018</option>
                <option value=2019>2019</option>
			</select></span>  
</p>

<p class="f_half left"> 
      <label class="col1">Card Verification Number:</label>
<span class="col2"><input  class="mid2" type=text size=3 maxlength=4 name=cvv2Number></span>  
</p>


</div>

<h3>Billing Address:</h3>

<div class="full clearfix box"> <br />
 
<p class="f_half left"> 
<label class="col1">Address 1:</label>
<span class="col2"><input  class="mid2" type=text size=25 maxlength=100 name=address1 value="<?php echo $data['billing']['address']; ?>"></span>
</p>
<p class="f_half left">
<label class="col1">Address 2:</label>
<span class="col2"><input  class="mid2" type=text  size=25 maxlength=100 name=address2 value="<?php echo $data['billing']['address1']; ?>">(optional)</span> 
</p>
<div class="clearfix"></div>
<p class="f_half left"> 
<label class="col1">Country:</label>

<span class="col2">
<select name="country" id="country"  class="short" tabindex="10"> 
                <?php if(isset($_POST['form']['country'])){ ?><option value="<?php echo $_POST['form']['country']; ?>"><?php echo $_POST['form']['country']; ?></option><?php } ?>               
                <?php if(file_exists(PPT_THEME_DIR. '/_countrylist.php')){ include(PPT_THEME_DIR. '/_countrylist.php' ); } ?>
</select>

</span>
</p>
<p class="f_half left"> 
<label class="col1">City:</label>
<span class="col2">

<input  class="mid2" type=text size=25 maxlength=40 name=city value="<?php echo $data['billing']['city']; ?>">
<input type="hidden"  class="mid2" id=state name=state value=""> </span>
</p>
<div class="clearfix"></div>


<p class="f_half left"> 
<label class="col1">State:</label>
<select  class="mid2" id=state name=state>
				<option value=></option>
				<option value=AK>AK</option>
				<option value=AL>AL</option>
				<option value=AR>AR</option>
				<option value=AZ>AZ</option>
				<option value=CA selected>CA</option>
				<option value=CO>CO</option>
				<option value=CT>CT</option>
				<option value=DC>DC</option>
				<option value=DE>DE</option>
				<option value=FL>FL</option>
				<option value=GA>GA</option>
				<option value=HI>HI</option>
				<option value=IA>IA</option>
				<option value=ID>ID</option>
				<option value=IL>IL</option>
				<option value=IN>IN</option>
				<option value=KS>KS</option>
				<option value=KY>KY</option>
				<option value=LA>LA</option>
				<option value=MA>MA</option>
				<option value=MD>MD</option>
				<option value=ME>ME</option>
				<option value=MI>MI</option>
				<option value=MN>MN</option>
				<option value=MO>MO</option>
				<option value=MS>MS</option>
				<option value=MT>MT</option>
				<option value=NC>NC</option>
				<option value=ND>ND</option>
				<option value=NE>NE</option>
				<option value=NH>NH</option>
				<option value=NJ>NJ</option>
				<option value=NM>NM</option>
				<option value=NV>NV</option>
				<option value=NY>NY</option>
				<option value=OH>OH</option>
				<option value=OK>OK</option>
				<option value=OR>OR</option>
				<option value=PA>PA</option>
				<option value=RI>RI</option>
				<option value=SC>SC</option>
				<option value=SD>SD</option>
				<option value=TN>TN</option>
				<option value=TX>TX</option>
				<option value=UT>UT</option>
				<option value=VA>VA</option>
				<option value=VT>VT</option>
				<option value=WA>WA</option>
				<option value=WI>WI</option>
				<option value=WV>WV</option>
				<option value=WY>WY</option>
				<option value=AA>AA</option>
				<option value=AE>AE</option>
				<option value=AP>AP</option>
				<option value=AS>AS</option>
				<option value=FM>FM</option>
				<option value=GU>GU</option>
				<option value=MH>MH</option>
				<option value=MP>MP</option>
				<option value=PR>PR</option>
				<option value=PW>PW</option>
				<option value=VI>VI</option>
			</select>

</p>
<p class="f_half left"> 
<label class="col1">Postal/ZIP Code:</label>
<span class="col2"><input  class="mid2" type=text size=10 maxlength=10 name=zip value="<?php echo $data['billing']['postcode']; ?>"> (5 or 9 digits)</span>
</p>


</div>
 
<div class="clear"></div>
<hr />
<center><input type="submit" value="Process Payment" class="green button"></center>

 </div>
</form>
 
 
<script language="javascript">
	generateCC();
</script>

<?php }
 
 
 
 
 
function gateway_blank_form($data=""){ ?>

<form method="POST" action="<?php echo get_option('gateway_blank_form_callback'); ?>">
<input type="hidden" name="customgateway" value="blankform" />
 
<input type="hidden" name="custom[amount]" value="<?php echo $data['price']['total']; ?>">
<input type="hidden" name="custom[order_id]" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="custom[description]" value="<?php echo strip_tags($data['description']); ?>">

<?php if($_POST['rec'] == 1){  
 
	if($_POST['rec_days'] < 6){
	$pb = $_POST['rec_days'];
	$pp = "Day";		
	}elseif($_POST['rec_days'] < 30){	
	$pb = round($_POST['rec_days']/7);	
	$pp = "Week";		
	}elseif($_POST['rec_days'] < 364){	
	$pb = round($_POST['rec_days']/30);	
	$pp = "Month";
	}elseif($_POST['rec_days'] == 365){
	$pb=1;
	$pp = "Year";
	}
?>
<input type="hidden" value="<?php echo $pp; ?>" name="custom[billingPeriod]">
<input type="hidden" value="<?php echo $pb; ?>" name="custom[billingFreq]">

<?php }else{ ?>
<input type="hidden" value="0" name="custom[recurring]">
<?php }   ?>

<h3>Payment Details</h3>

<div class="full clearfix border_t box"> 
 
<p class="f_half left"> 
  <label class="col1">First Name:</label>   
  <input  class="mid2" type=text size=30 maxlength=32 name="custom[firstName]" value="<?php echo $data['billing']['fname']; ?>"> 
</p>

<p class="f_half left"> 
        <label class="col1">Last Name:</label> 
        <input class="mid2"  type=text size=30 maxlength=32 name="custom[lastName]" value="<?php echo $data['billing']['flname']; ?>">
</p>

<div class="clearfix"></div>

<p class="f_half left"> 
  <label class="col1">Card Type:</label> 
<span class="col2"><select class="mid2" name="custom[creditCardType]">
				<option value="Visa" selected>Visa</option>
				<option value="MasterCard">MasterCard</option>
				<option value="Discover">Discover</option>
				<option value="Amex">American Express</option>
			</select></span>      
</p>

<p class="f_half left"> 
    <label class="col1">Card Number:</label> 
<span class="col2"><input class="mid2" type=text  size=30 maxlength=19 name="custom[creditCardNumber]"></span>    
</p>


<div class="clearfix"></div>

<p class="f_half left"> 
      <label class="col1">Expiration Date:</label>
<span class="col2"><select  class="mid2" name="custom[expDateMonth]">
				<option value=1>01</option>
				<option value=2>02</option>
				<option value=3>03</option>
				<option value=4>04</option>
				<option value=5>05</option>
				<option value=6>06</option>
				<option value=7>07</option>
				<option value=8>08</option>
				<option value=9>09</option>
				<option value=10>10</option>
				<option value=11>11</option>
				<option value=12>12</option>
			</select>
			<select  class="mid2" name="custom[expDateYear]">			  
				<option value=2012>2012</option>
				<option value=2013>2013</option>
				<option value=2014>2014</option>
				<option value=2015>2015</option>
                <option value=2016>2016</option>
                <option value=2017>2017</option>
                <option value=2018>2018</option>
                <option value=2019>2019</option>
			</select></span>  
</p>

<p class="f_half left"> 
      <label class="col1">Card Verification Number:</label>
<span class="col2"><input  class="mid2" type=text size=3 maxlength=4 name="custom[cvv2Number]"></span>  
</p>


</div>

<h3>Billing Address:</h3>

<div class="full clearfix border_t box"> <br />
 
<p class="f_half left"> 
<label class="col1">Address 1:</label>
<span class="col2"><input  class="mid2" type=text size=25 maxlength=100 name="custom[address1]" value="<?php echo $data['billing']['address']; ?>"></span>
</p>
<p class="f_half left">
<label class="col1">Address 2:</label>
<span class="col2"><input  class="mid2" type=text  size=25 maxlength=100 name="custom[address2]" value="<?php echo $data['billing']['address1']; ?>"></span> 
</p>
<div class="clearfix"></div>
<p class="f_half left"> 
<label class="col1">Country:</label>
<span class="col2">

 <select name="custom[state]" id="country" onchange="PremiumPressChangeState(this.value)" class="short" tabindex="10"> 
                <?php if(isset($ADD[0])){ ?><option value="<?php echo $ADD[0] ?>"><?php echo $ADD[0] ?></option><?php } ?>               
                <?php include(str_replace("functions/","",THEME_PATH)."_countrylist.php"); ?>
 </select> 

</span>
</p>
<p class="f_half left" style="margin-top:-25px;"> 


<div id="PremiumPressState"></div> 

</p>
<div class="clearfix"></div>
<p class="f_half left"> 
<label class="col1">ZIP/Postal Code:</label>
<span class="col2"><input  class="mid2" type=text size=10 maxlength=10 name="custom[zip]" value="<?php echo $data['billing']['postcode']; ?>"></span>
</p>


</div>
 
<div class="clear"></div>
<center><input type="submit" value="Process Payment" style="font-size:18px;" class="button gray"></center>

 </div>
</form>
 

<?php } 
 
 
 
function gateway_ewayAPI($data=""){

$total = str_replace(".","",$data['price']['total']);
if(strlen($total) == 3){ $total .=0; }
if(strlen($total) == 1 || strlen($total) == 2){ $total .="00"; }
?>

<form id="Form1" method="post" action="" ENCTYPE="multipart/form-data">
<input name="cid" type="hidden" id="txtInvDesc" value="<?php echo get_option('ewayAPI_customerID'); ?>" />
<input name="txtInvDesc" type="hidden" id="txtInvDesc" value="<?php echo $data['orderid']; ?>" />
<input name="txtInvRef" type="hidden" id="txtInvRef" value="<?php echo $data['orderid']; ?>"/>
<input name="txtTxnNumber" type="hidden" id="txtTxnNumber" value="<?php echo $data['orderid']; ?>"/>
<input name="txtAmount" type="hidden" id="txtAmount" value="<?php echo $total; ?>" />
<input name="callback" type="hidden" value="<?php echo get_option('ewayAPI_callback').'?order_id='.$data['orderid'] ?>" />
<input name="emethod" type="hidden" value="<?php echo get_option('ewayAPI_paymentmethod') ?>" />
<input name="elive" type="hidden" value="<?php echo get_option('ewayAPI_live') ?>" />

<div style="width:580px;clear:both;">

<h2>Payment Details</h2>
<hr>
<br />
<div class="row"><label class="col1">First Name:</label>
<span class="col2"><input class="mid2" name="txtFirstName" type="text" id="txtFirstName" value="<?php echo $data['billing']['fname']; ?>" /></span></div>

<div class="row"><label class="col1">Last Name:</label>
<span class="col2"><input class="mid2" name="txtLastName" type="text" id="txtLastName" value="<?php echo $data['billing']['lname']; ?>" /></span></div>

<div class="row"><label class="col1">Email Address:</label>
<span class="col2"><input class="mid2" name="txtEmail" type="text" id="txtEmail" value="<?php echo $data['billing']['email']; ?>" /></span></div>

<div class="row"><label class="col1">Address:</label>
<span class="col2"><input class="mid2" name="txtAddress" type="text" id="txtAddress" value="<?php echo $data['billing']['address']; ?>" /></span></div>

<div class="row"><label class="col1">Postcode:</label>
<span class="col2"><input class="mid2" name="txtPostcode" type="text" id="txtPostcode" value="<?php echo $data['billing']['postcode']; ?>" /></span>
 <br />
 
 
<div class="clear"></div>

<div class="row"><label class="col1">Card Type:</label>
<span class="col2"><select class="mid2" name="ddlCardType" id="ddlCardType">
		<option value="VISA">VISA</option>
		<option value="MASTERCARD">MASTERCARD</option>
		<option value="AMEX">AMEX</option>
	</select></span></div>

<div class="row"><label class="col1">Card Holders Name:</label>
<span class="col2"><input class="mid2" name="txtCCName" type="text" id="txtCCName" /></span></div>

<div class="row"><label class="col1">Card Number:</label>
<span class="col2"><input class="mid2" name="txtCCNumber" type="text" maxlength="17" id="txtCCNumber" /></span></div>
 

<div class="row"><label class="col1">Card CSV Number: <br /><small>(3 digits on the back)</small></label>
<span class="col2"><input class="mid2" name="txtCSVNumber" type="text" maxlength="5" id="txtCSVNumber"  style="width:20px;"/></span></div>

<div class="row"><label class="col1">Card Expiry:</label>
<span class="col2"><select class="mid2" name="ddlExpiryMonth" id="ddlExpiryMonth">
		<option value="01">01</option>
		<option value="02">02</option>
		<option value="03">03</option>
		<option value="04">04</option>
		<option value="05">05</option>
		<option value="06">06</option>
		<option value="07">07</option>
		<option value="08">08</option>
		<option value="09">09</option>
		<option value="10">10</option>
		<option value="11">11</option>
		<option value="12">12</option>
	</select>
<select class="mid2" name="ddlExpiryYear" id="ddlExpiryYear">
		<option value="10">10</option>
		<option value="11">11</option>
		<option value="12">12</option>
		<option value="13">13</option>
		<option value="14">14</option>
		<option value="15">15</option>
		<option value="16">16</option>
		<option value="17">17</option>
        <option value="18">18</option>
        <option value="19">19</option>
	</select></span></div>



 

<center><input type="submit" name="btnProcess" value="Process Transaction" id="btnProcess"  style="font-size:18px;" /></center>
</div> 
</form>


<?php
 
}

function gateway_nochex($data=""){

?>

<form method="POST" action="https://secure.nochex.com/" name="gateway_noxhex" id="gateway_noxhex">
	<input type="hidden" name ="merchant_id" value="<?php echo get_option('nochex_mid'); ?>">
	<input type="hidden" name ="amount" value="<?php echo $data['price']['total']; ?>">
	<input type="hidden" name ="description" value="<?php echo strip_tags($data['description']); ?>">
	<input type="hidden" name ="order_id" value="<?php echo $data['orderid']; ?>">
    <input type="hidden" name ="callback_url" value="<?php echo get_option('gateway_nochex_callback').'?order_id='.$data['orderid'] ?>">
    <?php echo MakePayButton('javascript:document.gateway_noxhex.submit();'); ?>
 
	</form>


<?php 

}

function trimAmountForEpay($amount) {
	$res = "";
	for ($i = 0; $i < strlen($amount); $i++) {
		$letter = substr($amount, $i, 1);
		if ($letter == "0" || $letter == "1" || $letter == "2" || $letter == "3" || $letter == "4" || $letter == "5" || $letter == "6" || $letter == "7" || $letter == "8" || $letter == "9") {
			$res = ($res . $letter);
		}
	}
	return $res;
}


function gateway_epay($data=""){

  echo '<form action="https://ssl.ditonlinebetalingssystem.dk/popup/default.asp" method="post" name="ePay" id="ePay">
  				<input type="hidden" name="merchantnumber" value="' . get_option('epay_merchantnumber') . '">
  				<input type="hidden" name="amount" value="' . trimAmountForEpay($data['price']['total'] * 100). '">
  				<input type="hidden" name="currency" value="' . get_option('epay_currency') . '">
  				<input type="hidden" name="orderid" value="' . $data['orderid'] . '">
  				<input type="hidden" name="windowstate" value="2">
  				<input type="hidden" name="instantcallback" value="1">

  				<input type="hidden" name="accepturl" value="' . get_option('epay_callback') . '">
  				<input type="hidden" name="declineurl" value="' . get_option('epay_callback') . '">
  				<input type="hidden" name="callbackurl" value="' . get_option('epay_callback').'/?epay_callback=1' . '">
  				<input type="hidden" name="md5key" value="' . md5(get_option('epay_currency') . trimAmountForEpay($data['price']['total'] * 100) . $data['orderid'] . get_option('epay_md5key')) . '">
  				
  				<input type="hidden" name="addfee" value="' . get_option('epay_addfee') . '">
  				<input type="hidden" name="splitpayment" value="' . get_option('epay_splitpayment') . '">
  				<input type="hidden" name="authsms" value="' . get_option('epay_authsms') . '">
  				<input type="hidden" name="authmail" value="' . get_option('epay_authmail') . '">
  				<input type="hidden" name="group" value="' . get_option('epay_group') . '">
  				<input type="hidden" name="instantcapture" value="0">
  				
  			</form>';

}

function gateway_realex($data=""){

$curr			= get_option('realex_currency');
$amount 		= str_replace(".","",str_replace(",","",$data['price']['total']));//*10
$merchantid 	= get_option('realex_mid');
$timestamp 		= strftime("%Y%m%d%H%M%S");
$orderid		= str_replace("","",$data['orderid']);
$secret			= get_option('realex_secret');
mt_srand((double)microtime()*1000000);

$tmp = "$timestamp.$merchantid.$orderid.$amount.$curr";
$md5hash = md5($tmp);
$tmp = "$md5hash.$secret";
$md5hash = md5($tmp);
?>

<form method="POST" action="https://epage.payandshop.com/epage.cgi" name="gateway_realex" id="gateway_realex"> 
<input type="hidden" name="MERCHANT_ID" value="<?php echo $merchantid; ?>"> 
<input type="hidden" name="ORDER_ID" value="<?php echo $orderid; ?>"> 
<input type="hidden" name="ACCOUNT" value="<?php echo get_option('realex_sub'); ?>"> 
<input type="hidden" name="AMOUNT" value="<?php echo $amount; ?>"> 
<input type="hidden" name="CURRENCY" value="<?php echo $curr; ?>"> 
<input type="hidden" name="TIMESTAMP" value="<?php echo $timestamp; ?>"> 
<input type="hidden" name="MD5HASH" value="<?php echo $md5hash; ?>"> 
<input type="hidden" name="AUTO_SETTLE_FLAG" value="1"> 
 <?php echo MakePayButton('javascript:document.gateway_realex.submit();'); ?>
 
</form>

<?php

}

function gateway_eway_uk($data=""){

$total = $data['price']['total'];
if(strlen($total) == 3){ $total .=0; }
if(strlen($total) == 1 || strlen($total) == 2){ $total .=".00"; }
?>

<form id="Form1" method="post" action="" name="gateway_ewayUK">
<input type="hidden" name="ewayUK" value="1">
<input type="hidden" name="customgateway" value="ewayUK">
<input type="hidden" name="Amount" value="<?php echo $total; ?>">
<input type="hidden" name="InvoiceDescription" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="CustomerID" value="<?php echo get_option('eway_uk_cid'); ?>">
<input type="hidden" name="RefNum" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="Invoice" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="ModDetails" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="company" value="<?php echo get_option('eway_uk_company'); ?>" />
<input type="hidden" name="username" value="<?php echo get_option('eway_uk_username'); ?>" />
<input type="hidden" name="callback" value="<?php echo get_option('eway_uk_callback'); ?>" />

<input type="hidden" name="n1" value="<?php echo $data['billing']['fname']; ?>" />
<input type="hidden" name="n2" value="<?php echo $data['billing']['lname']; ?>" />
<input type="hidden" name="n3" value="<?php echo $data['billing']['email']; ?>" />
<input type="hidden" name="n4" value="<?php echo $data['billing']['address1']; ?>" />
<input type="hidden" name="n5" value="<?php echo $data['billing']['zip']; ?>" />
<input type="hidden" name="n6" value="<?php echo $data['billing']['country']; ?>" />
<input type="hidden" name="n7" value="<?php echo $data['billing']['city']; ?>" />
<input type="hidden" name="n8" value="<?php echo $data['billing']['phone']; ?>" />
<input type="hidden" name="n9" value="<?php echo $data['billing']['state']; ?>" />
<?php echo MakePayButton('javascript:document.gateway_ewayUK.submit();'); ?>
 
</form>

<?php

}


function gateway_eway_nz($data=""){

$total = $data['price']['total'];
if(strlen($total) == 3){ $total .=0; }
if(strlen($total) == 1 || strlen($total) == 2){ $total .=".00"; }
?>

<form id="Form1" method="post" action="" name="gateway_ewayNZ">
<input type="hidden" name="ewayNZ" value="1">
<input type="hidden" name="customgateway" value="ewayNZ">

<input type="hidden" name="Amount" value="<?php echo $total; ?>">
<input type="hidden" name="InvoiceDescription" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="CustomerID" value="<?php echo get_option('eway_nz_cid'); ?>">
<input type="hidden" name="RefNum" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="Invoice" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="ModDetails" value="<?php echo $data['orderid']; ?>">
<input type="hidden" name="company" value="<?php echo get_option('eway_nz_company'); ?>" />
<input type="hidden" name="username" value="<?php echo get_option('eway_nz_username'); ?>" />
<input type="hidden" name="callback" value="<?php echo get_option('eway_nz_callback'); ?>" />

<input type="hidden" name="n1" value="<?php echo $data['billing']['fname']; ?>" />
<input type="hidden" name="n2" value="<?php echo $data['billing']['lname']; ?>" />
<input type="hidden" name="n3" value="<?php echo $data['billing']['email']; ?>" />
<input type="hidden" name="n4" value="<?php echo $data['billing']['address1']; ?>" />
<input type="hidden" name="n5" value="<?php echo $data['billing']['zip']; ?>" />
<input type="hidden" name="n6" value="<?php echo $data['billing']['country']; ?>" />
<input type="hidden" name="n7" value="<?php echo $data['billing']['city']; ?>" />
<input type="hidden" name="n8" value="<?php echo $data['billing']['phone']; ?>" />
<input type="hidden" name="n9" value="<?php echo $data['billing']['state']; ?>" />
<?php echo MakePayButton('javascript:document.gateway_ewayNZ.submit();'); ?>
 
</form>

<?php

}

function gateway_alipay($data=""){

require_once("gateway_alipay/alipay_service.php");

$partner        = get_option('alipay_pid');
$security_code  = get_option('alipay_code');
$seller_email   = get_option('alipay_email');
$_input_charset = "GBK";  //Character encoding format currently supports GBK or utf-8
$sign_type      = "MD5";    //Encryption system default (do not modify)
$transport      = "https";  //Access mode, you can own server to choose whether to support http and ssl access https access mode (the system default, do not modify)
$notify_url     = get_option('alipay_callback');
$return_url     = get_option('alipay_callback');
$show_url       = "";        //Add your site display of goods

$parameter = array(
	"service"        => "trade_create_by_buyer",  //Transaction type
	"partner"        => $partner,         //No. co-tenants
	"return_url"     => $return_url,      //Sync return
	"notify_url"     => $notify_url,      //Asynchronous Back
	"_input_charset" => $_input_charset,  //Character set, default is GBK
	"subject"        => "Cart ID ".$data['orderid'],       //Name, required
	"body"           => "Cart Products",       //Commodity description, required
	"out_trade_no"   => date(Ymdhms),     //Number of external trade of goods, required (to ensure uniqueness)
	"price"          => $data['price']['total'],           //Commodity Price, required (price can not be 0)
	"payment_type"   => "1",              //The default is 1, do not need to modify
	"quantity"       => "1",              //Number of commodities, required
		
	"logistics_fee"      =>'0.00',        //Logistics and distribution costs
	"logistics_payment"  =>'BUYER_PAY',   //Logistics costs of payment: SELLER_PAY (Seller pays), BUYER_PAY (buyer to pay), BUYER_PAY_AFTER_RECEIVE (COD)
	"logistics_type"     =>'EXPRESS',     //Distribution method: POST (surface), EMS (EMS), EXPRESS (other Express)

	"show_url"       => $show_url,        //Goods related websites
	"seller_email"   => $seller_email     //E-mail the seller, must be filled
);

$alipay = new alipay_service($parameter,$security_code,$sign_type);
$link	=	$alipay->create_url();
?>
<?php echo MakePayButton($link); ?>
 
<?php 
 

}


function gateway_moneybookers($data=""){

return '<form action="https://www.moneybookers.com/app/payment.pl" name="moneybook" id="moneybook">
<input type="hidden" name="pay_to_email" value="'.get_option('moneybookers_email').'">
<input type="hidden" name="transaction_id" value="'.$data['orderid'].'">
<input type="hidden" name="return_url" value="'.get_option('moneybookers_callback').'">
<input type="hidden" name="cancel_url" value="'.get_option('moneybookers_callback').'">
<input type="hidden" name="language" value="EN">
<input type="hidden" name="pay_from_email" value="">
<input type="hidden" name="amount" value="'.$data['price']['total'].'">
<input type="hidden" name="currency" value="USD">
<input type="hidden" name="firstname" value="'.$data['billing']['fname'].'">
<input type="hidden" name="lastname" value="'.$data['billing']['lname'].'">
<input type="hidden" name="address" value="'.$data['billing']['address1'].'">
<input type="hidden" name="postal_code" value="'.$data['billing']['zip'].'">
<input type="hidden" name="city" value="'.$data['billing']['city'].'">
<input type="hidden" name="country" value="'.$data['billing']['country'].'">
<input type="hidden" name="detail1_description" value="Cart ID: '.$data['orderid'].'">
<input type="hidden" name="detail1_text" value="">'.MakePayButton('javascript:document.moneybook.submit();').'</form>';


}
 
function gateway_monsterpay($data=""){ ?>

<FORM METHOD="POST" ACTION="https://www.monsterpay.com/secure/" name="monsterpay">
<INPUT TYPE="HIDDEN" NAME="ButtonAction" VALUE="checkout">
<INPUT TYPE="HIDDEN" NAME="MerchantIdentifier" VALUE="<?php echo get_option('monsterpay_mid'); ?>">
<INPUT TYPE="HIDDEN" NAME="CurrencyAlphaCode" VALUE="<?php echo get_option('monsterpay_currency'); ?>">
<INPUT TYPE="HIDDEN" NAME="LIDSKU" VALUE="<?php echo $data['orderid']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDDesc" VALUE="<?php echo $data['orderid']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDPrice" VALUE="<?php echo $data['price']['total']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDQty" VALUE="1">
<?php echo MakePayButton('javascript:document.monsterpay.submit();'); ?>
 

</FORM>

<?php }
 
function gateway_setcom($data=""){ ?>

<FORM METHOD="POST" ACTION="https://www.setcom.com/secure/" name="setcom">
<INPUT TYPE="HIDDEN" NAME="ButtonAction" VALUE="checkout">
<INPUT TYPE="HIDDEN" NAME="MerchantIdentifier" VALUE="<?php echo get_option('monsterpay_mid'); ?>">
<INPUT TYPE="HIDDEN" NAME="CurrencyAlphaCode" VALUE="USD">
<INPUT TYPE="HIDDEN" NAME="LIDSKU" VALUE="<?php echo $data['orderid']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDDesc" VALUE="<?php echo $data['orderid']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDPrice" VALUE="<?php echo $data['price']['total']; ?>">
<INPUT TYPE="HIDDEN" NAME="LIDQty" VALUE="1">
<?php echo MakePayButton('javascript:document.setcom.submit();'); ?>

 
</FORM>

<?php } 

function gateway_paytrace($data=""){ ?>


	<form action="<?php echo get_option('paytrace_callback'); ?>" method="post" name="paytrace">
    <input name="amount" type="hidden" id="txtAmount" value="<?php echo $data['price']['total']; ?>" />
    <input name="orderid" type="hidden" id="txtTxnNumber" value="<?php echo $data['orderid']; ?>"/>     
    <input type="hidden" name="customgateway" value="payTrace" />
    
    
<div class="row"><label class="col1">Credit Card Number:</label>
<span class="col2"><input type="text" name="cc_num"></span></div>
<br />


<div class="row"><label class="col1">Card Expiry:</label>
<span class="col2"><select class="mid2" name="exp_month">
		<option value="01">01</option>
		<option value="02">02</option>
		<option value="03">03</option>
		<option value="04">04</option>
		<option value="05">05</option>
		<option value="06">06</option>
		<option value="07">07</option>
		<option value="08">08</option>
		<option value="09">09</option>
		<option value="10">10</option>
		<option value="11">11</option>
		<option value="12">12</option>
	</select>
<select class="mid2" name="exp_year">
		<option value="12">12</option>
		<option value="13">13</option>
		<option value="14">14</option>
		<option value="15">15</option>
		<option value="16">16</option>
		<option value="17">17</option>
        <option value="18">18</option>
        <option value="19">19</option>
	</select></span></div>
    
<div class="row"><label class="col1">Card CSC Number: <br /><small>(3 digits on the back)</small></label>
<span class="col2"><input class="mid2" name="csc" type="text" maxlength="5"  style="width:20px;"/></span></div>

    
 
		<span class="twoColumn">
			<label>Billing Street</label>
			<input type="text" name="street">
		</span>
		<span class="oneColumn">
			<label>BIlling Zip/Postcode</label>
			<input type="text" name="zip">
		</span>
        
        <br />
		 
			<center><input type="submit" name="payTrace" value="Process Transaction"  style="font-size:18px;" class="button gray right" /></center>
			<input type="hidden" name="submitted" value="TRUE">
		 
	</form>

 
 

<?php }



function createhash($PreSharedKey,$Password,$data, $time)
{ 
 
global $wpdb;

  $str="PreSharedKey=" . get_option('gateway_cardsave_mKEY');
  $str=$str . '&MerchantID=' . get_option('gateway_cardsave_mID');
  $str=$str . '&Password=' . get_option('gateway_cardsave_mp');
  $str=$str . '&Amount=' . str_replace(".","",$data['price']['total']);
  $str=$str . '&CurrencyCode=' . get_option('gateway_cardsave_currency');
  $str=$str . '&OrderID=' . $data['orderid'];
  $str=$str . '&TransactionType=' . 'SALE';
  $str=$str . '&TransactionDateTime=' . $time;
  $str=$str . '&CallbackURL=' . get_option('gateway_cardsave_callback');
  $str=$str . '&OrderDescription=' . $_POST["OrderDescription"];
  $str=$str . '&CustomerName=' . $_POST["CustomerName"];
  $str=$str . '&Address1=' . $_POST["Address1"];
  $str=$str . '&Address2=' . $_POST["Address2"];
  $str=$str . '&Address3=' . $_POST["Address3"];
  $str=$str . '&Address4=' . $_POST["Address4"];
  $str=$str . '&City=' . $_POST["City"];
  $str=$str . '&State=' . $_POST["State"];
  $str=$str . '&PostCode=' . $_POST["PostCode"];
  $str=$str . '&CountryCode=' . $_POST["CountryCode"];
  
  $str=$str . "&CV2Mandatory=false";
  $str=$str . "&Address1Mandatory=false";
  $str=$str . "&CityMandatory=false";
  $str=$str . "&PostCodeMandatory=false";
  $str=$str . "&StateMandatory=false";
  $str=$str . "&CountryMandatory=false";
  
  $str=$str . "&ResultDeliveryMethod=" . 'POST';
  $str=$str . "&ServerResultURL=" . get_option('gateway_cardsave_callback');
  $str=$str . "&PaymentFormDisplaysResult=" . 'false';
  return (sha1($str));
}     
 
function gateway_cardsave($data=""){ global $wpdb; $time = date('Y-m-d H:i:s P'); ?>

<form name="cardsave" id="cardsave" method="post" action="https://mms.cardsaveonlinepayments.com/Pages/PublicPages/PaymentForm.aspx">
		
				<input type="hidden" name="HashDigest" value="<?php echo createhash($PreSharedKey,$Password,$data, $time); ?>" />
				<input type="hidden" name="MerchantID" value="<?php echo get_option('gateway_cardsave_mID'); ?>" />
				<input type="hidden" name="Amount" value="<?php echo str_replace(".","",$data['price']['total']); ?>" />                                      
				<input type="hidden" name="CurrencyCode" value="<?php echo get_option('gateway_cardsave_currency'); ?>" />
				<input type="hidden" name="OrderID" value="<?php echo $data['orderid']; ?>" />
				<input type="hidden" name="TransactionType" value="SALE" />
				<input type="hidden" name="TransactionDateTime" value="<?php echo $time; ?>" />
				<input type="hidden" name="CallbackURL" value="<?php echo get_option('gateway_cardsave_callback'); ?>" />
				<input type="hidden" name="OrderDescription" value="<?php echo $_POST["OrderDescription"]; ?>" />
				<input type="hidden" name="CustomerName" value="<?php echo $_POST["CustomerName"]; ?>" />
				<input type="hidden" name="Address1" value="<?php echo $_POST["Address1"]; ?>" />
				<input type="hidden" name="Address2" value="<?php echo $_POST["Address2"]; ?>" />
				<input type="hidden" name="Address3" value="<?php echo $_POST["Address3"]; ?>" />
				<input type="hidden" name="Address4" value="<?php echo $_POST["Address4"]; ?>" />
				<input type="hidden" name="City" value="<?php echo $_POST["City"]; ?>" /> 
				<input type="hidden" name="State" value="<?php echo $_POST["State"]; ?>" />
				<input type="hidden" name="PostCode" value="<?php echo $_POST["PostCode"]; ?>" />
				<input type="hidden" name="CountryCode" value="<?php echo $_POST["CountryCode"]; ?>" />
                
				<input type="hidden" name="CV2Mandatory" value="false" />
				<input type="hidden" name="Address1Mandatory" value="false" />
				<input type="hidden" name="CityMandatory" value="false" />
				<input type="hidden" name="PostCodeMandatory" value="false" />
				<input type="hidden" name="StateMandatory" value="false" />
				<input type="hidden" name="CountryMandatory" value="false" />
                
				<input type="hidden" name="ResultDeliveryMethod" value="POST" />
				<input type="hidden" name="ServerResultURL" value="<?php echo get_option('gateway_cardsave_callback'); ?>" />
				<input type="hidden" name="PaymentFormDisplaysResult" value="false" />
                
<?php echo MakePayButton('javascript:document.cardsave.submit();'); ?>
  
                
  			 	
			</form>

<?php }



function gateway_totalwebsolutions($data=""){ global $userdata;   ?>


<form method="POST" action="https://testsecure.totalwebsecure.com/PayPage/Clear.asp" name="totalwebsolutions" id="totalwebsolutions">

<input type="hidden" name="customerid" value="<?php echo get_option('gateway_totalwebsolutions_ID'); ?>" />
<input type="hidden" name="TransactionCurrency" value="<?php echo get_option('gateway_totalwebsolutions_currency'); ?>" />
<input type="hidden" name="TransactionAmount" value="<?php echo $data['price']['total']; ?>" />
<input type="hidden" name="Notes" value="<?php echo $data['orderid']; ?>" />
<input type="hidden" name="CustomerEmail" value="<?php if(isset($userdata->user_email)){ echo $userdata->user_email; }else{ echo get_option('admin_email'); }?>" />
<input type="hidden" name="RedirectorSuccess" value="<?php echo get_option('gateway_totalwebsolutions_callback'); ?>?order_id=<?php echo $data['orderid']; ?>" />
<input type="hidden" name="RedirectorFailed" value="<?php echo get_option('gateway_totalwebsolutions_callback'); ?>" />
 
<?php echo MakePayButton('javascript:document.totalwebsolutions.submit();'); ?>
 
 
</form> 
<?php }  ?>