<?php

	/***************** DO NOT EDIT THIS FILE *************************
	******************************************************************
	
	INFORMATION:
	------------
	
	This is a core configuration file for the PremiumPress framework
	developed by Mark Fail, CEO of PremiumPress www.premiumpress.com
	
	LAST UPDATED: June 26th 2011
	EDITED BY: MARK FAIL
	------------------------------------------------------------------
	
	******************************************************************/
	
	// Defines the current version of the Framework.
	define( 'PPT_VERSION', '2.0' );
 
 	//load framework
	require_once (TEMPLATEPATH ."/PPT/framework/ppt_api.php");
	require_once (TEMPLATEPATH ."/PPT/framework/ppt.php");
	require_once (TEMPLATEPATH ."/PPT/framework/ppt_core.php");
	require_once (TEMPLATEPATH ."/PPT/framework/ppt_admin.php"); 
	require_once (TEMPLATEPATH ."/PPT/framework/ppt_widgets.php"); 
	require_once (TEMPLATEPATH ."/PPT/framework/ppt_mobile.php");
			
	// Define a few default constants.
	ppt_initial_constants();
	
	// Define the templating constants.
	ppt_templating_constants();	
	
	if(!file_exists(PPT_CHILD_DIR."/system_customdesign.php") )
	die("<h1>Theme Install Error</h1> No theme folder found ".PPT_CHILD_DIR." ");
	
	// Load all PremiumPress classes.
	require_once (TEMPLATEPATH ."/PPT/class/class_premiumpress.php");
	require_once (TEMPLATEPATH ."/PPT/class/class_design.php"); 
	require_once (TEMPLATEPATH ."/PPT/class/class_member.php");	
	require_once (TEMPLATEPATH ."/PPT/class/class_image.php");	
	
	// Load all custom theme classes.
	require_once (PPT_CHILD_DIR."/system_customdesign.php");

	// CUSTOM THEME FUNCTIONS
	require_once (TEMPLATEPATH ."/PPT/func/funcs_premiumpress.php");		

	// ADMIN AREA INCLUDES
	require_once (TEMPLATEPATH . '/admin/admin-save.php');	
 
	// Load in any custom child theme functionality
	if(file_exists(PPT_CUSTOM_CHILD_DIR."/_functions.php") ){				 
		include(PPT_CUSTOM_CHILD_DIR.'/_functions.php');					
	}	
	$PT	 			= new PPT;		
	$ThemeDesign 	= new Theme_Design;		
	$PPT 			= new PremiumPressTheme;  	
	$PPTDesign 		= new PremiumPressTheme_Design;					
	$PPTMobile 		= new PPT_MOBILE;
	
	// Registers the theme backbone class.
	//ppt_register_class( 'theme', 'PPT' ); 	
	
	// REMOVE THE ADMIN BAR FROM THE THEMES
	if(strtolower(PREMIUMPRESS_SYSTEM) != "shopperpress"){
	if(current_user_can('administrator')){ }else{
	add_filter( 'show_admin_bar', '__return_false' );
	}
	}
	// REMOVE CUSTOM WP FILTERS
	$filters = array('term_description' , 'category_description' , 'pre_term_description');
	foreach ( $filters as $filter ) {
	remove_filter($filter, 'wptexturize');
	remove_filter($filter, 'convert_chars');
	remove_filter($filter, 'wpautop');
	remove_filter($filter, 'wp_filter_kses');
	remove_filter($filter, 'strip_tags');
	}
			
	// Registers the Theme Options admin class.
	ppt_register_admin_class( 'options', 'PPT_Admin' );

 	$ppt_theme = PPT();	
	
	// LOAD IN ANY INIT HOOKS
	add_action('init', array( 'PPT','ppt_init') );	
 	
	// Load admin pages.
	add_action( 'init', 'ppt_load_admin_pages', 100 );
	
	$WordpressMenuArray = array(
	  'theme_location' => 'PPT-CUSTOM-MENU-PAGES',
	  'menu'            => '', 
	  'container'       => '', 
	  'container_class' => '', 
	  'container_id'    => '',
	  'menu_class'      => '', 
	  'menu_id'         => '',
	  'echo'            => false,
	  'fallback_cb'     => 'wp_page_menu',
	  'before'          => '',
	  'after'           => '',
	  'link_before'     => '',
	  'link_after'      => '',
	  'items_wrap'      => '<ul>%3$s</ul>', // class="menu"
	  'depth'           => 0,
	  'walker'          => ''); 
	 
 	$GLOBALS['blog_custom_menu'] = $WordpressMenuArray;
	$GLOBALS['bloginfo_url'] = HOME_URI;
	$GLOBALS['template_url'] = PPT_THEME_URI; 
	

	// REMOVE UNWANTED WIDGETS FROM PP THEMES	
	if(!function_exists('my_unregister_widgets')){
	
		add_action( 'widgets_init', 'my_unregister_widgets' );
		
		function my_unregister_widgets() {
		//unregister_widget('WP_Widget_Pages');
		unregister_widget('WP_Widget_Calendar');
		unregister_widget('WP_Widget_Archives');
		//unregister_widget('WP_Widget_Links');
		//unregister_widget('WP_Widget_Meta');
		unregister_widget('WP_Widget_Search');
		unregister_widget('WP_Widget_Categories');
		unregister_widget('WP_Widget_Recent_Posts');
		//unregister_widget('WP_Widget_Recent_Comments');
		//unregister_widget('WP_Widget_Tag_Cloud');
	    //unregister_widget('WP_Widget_RSS');
		unregister_widget('WP_Widget_Akismet');
		unregister_widget('WP_Nav_Menu_Widget');
		}	
	}
	
	
	// TEST CRON IMPORT
	//$PPTImport 		= new PremiumPressTheme_Import;	 
	//$PPTImport->IMPORTSWITCH('twicedaily');
	
?>